<?php 
namespace ElementPress\Modules\Controls;
defined( 'ABSPATH' ) || exit;
class Init{
    // instance of all control's base class
    // ##readhere
    public static function get_url(){
        return \ElementPress::module_url() . 'controls/';
    }
    public static function get_dir(){
        return \ElementPress::module_dir() . 'controls/';
    }
    public function __construct() {
        // Includes necessary files
      //add_action( 'wp_enqueue_scripts', array( $this, 'scripts' ) );

        add_action( 'wp_ajax_nopriv_send_bug_report', array( $this, 'send_bug_report' ) );
        add_action( 'wp_ajax_send_bug_report', array( $this, 'send_bug_report' ) );
        $this->include_files();
        add_action('elementor/controls/controls_registered', array( $this, 'icon' ), 11 );
        add_action('elementor/controls/controls_registered', array( $this, 'image_choose' ), 11 );
        add_action('elementor/controls/controls_registered', array( $this, 'ajax_select2' ), 11 );
        add_action('elementor/controls/controls_registered', array( $this, 'widgetarea' ), 11 );

    }
    private function include_files(){
          // Controls_Manager
          include_once self::get_dir() . 'control-manager.php';
          // image choose
          include_once self::get_dir() . 'image-choose.php';
          // ajax select2
          include_once self::get_dir() . 'ajax-select2.php';
          include_once self::get_dir() . 'ajax-select2-api.php';
          // widgetarea
          include_once self::get_dir() . 'widget-area-utils.php';
          include_once self::get_dir() . 'widget-area.php';
 
    }
    public function icon( $controls_manager ) {
        $controls_manager->unregister_control( $controls_manager::ICON );
        $controls_manager->register_control( $controls_manager::ICON, new \ElementPress\Modules\Controls\Icon());
    }

    public function ajax_select2( $controls_manager ) {
        $controls_manager->register_control('ajaxselect2', new \ElementPress\Modules\Controls\Ajax_Select2());
    }
    public function image_choose( $controls_manager ) {
        $controls_manager->register_control('imagechoose', new \ElementPress\Modules\Controls\Image_Choose());
    }
    public function widgetarea( $controls_manager ) {
        $controls_manager->register_control( 'widgetarea', new \ElementPress\Modules\Controls\Widget_Area());
    }
    public function widgetarea_enqueue_scripts_editor() {
		wp_enqueue_script( 'elementpress-js-widgetarea-control-editor',  self::get_url() . 'assets/js/widgetarea-editor.js' );
		wp_enqueue_script( 'elementpress-js-contact-from',  self::get_url() . 'assets/js/contact-from.js' );
    }
	public function widgetarea_enqueue_styles_editor() {
		wp_enqueue_style( 'elementpress-css-widgetarea-control-editor',  self::get_url() . 'assets/css/widgetarea-editor.css', [], '1.0.0' );
    }
    function send_bug_report() {

        $data = $_POST;

        $post_title = get_the_title( intval( $data['post_id'] ) );

        wp_mail( 'mohsin@akdesigner.com', 'Bug report in post: ' . $post_title, $data['report'] );

        wp_send_json_success( __( 'Thanks for reporting!', 'reportabug' ) );

    }
}