<?php
namespace Elementor;
use Elementor\Core\Schemes\Typography as Scheme_Typography;


if ( ! defined( 'ABSPATH' ) ) exit;

class Elementpress_Widget_Testimonial extends \Elementor\Widget_Base {

	public $base;
	public function __construct($data = [], $args = null) {
		parent::__construct($data, $args);
		wp_register_style( 'testimonial-css',  \ElementPress::widgets_url() . '/testimonial/assets/css/testimonial.css', false, \ElementPress::version );
		wp_register_script( 'slick-slider-js',  \ElementPress::widgets_url() . '/testimonial/assets/js/slick-slider.js', false, \ElementPress::version );
		wp_register_script( 'testimonial-js',  \ElementPress::widgets_url() . '/testimonial/assets/js/testimonial.js', false, \ElementPress::version );
		wp_register_style( 'elementpress-css-icon-control',  \ElementPress::module_url() . 'controls/assets/css/epressicons.css', [], '1.0.1' );


	 }

  
	  public function get_style_depends() {
		 
		 return [ 'testimonial-css','elementpress-css-icon-control' ];
	  }
    public function get_script_depends() {
		//built in function to load script when widget is active
		return [ 'slick-slider-js','testimonial-js' ];
    
    }

    public function get_name() {
        return 'elementpress-testimonial';
    }

    public function get_title() {
        return esc_html__( 'Testimonial', 'elementpress' );
    }

    public function get_icon() {
		return 'eicon-post-list';
    }

    public function get_categories() {
        return [ 'additional-addons' ];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'epress_testimonial_layout_section_tab_style',
            [
                'label' => esc_html__('Layout', 'elementpress'),
            ]
        );


        // // Card style

		$this->add_control(
            'epress_testimonial_style',
            [
                'label' => esc_html__('Choose Style', 'elementpress'),
                'type' => 'imagechoose',
                'default' => 'style1',
                'options' => [
					'style1' => [
						'title' => esc_html__( 'Default', 'elementpress' ),
                        'imagelarge' =>\ElementPress::widgets_url() . '/testimonial/assets/imagechoose/1.png',
                        'imagesmall' =>\ElementPress::widgets_url() . '/testimonial/assets/imagechoose/1.png',
                        'width' => '33.33%',
					],
					'style2' => [
						'title' => esc_html__( 'Grid Style without image', 'elementpress' ),
                        'imagelarge' =>\ElementPress::widgets_url() . '/testimonial/assets/imagechoose/2.png',
                        'imagesmall' =>\ElementPress::widgets_url() . '/testimonial/assets/imagechoose/2.png',
                        'width' => '33.33%',
					],
					'style3' => [
						'title' => esc_html__( 'Image with Ratting', 'elementpress' ),
                        'imagelarge' =>\ElementPress::widgets_url() . '/testimonial/assets/imagechoose/3.png',
                        'imagesmall' =>\ElementPress::widgets_url() . '/testimonial/assets/imagechoose/3.png',
                        'width' => '33.33%',
					],
					'style4' => [
						'title' => esc_html__( 'image style 4', 'elementpress' ),
                        'imagelarge' =>\ElementPress::widgets_url() . '/testimonial/assets/imagechoose/4.png',
                        'imagesmall' =>\ElementPress::widgets_url() . '/testimonial/assets/imagechoose/4.png',
                        'width' => '33.33%',
					],
					'style5' => [
						'title' => esc_html__( 'image style 5', 'elementpress' ),
                        'imagelarge' =>\ElementPress::widgets_url() . '/testimonial/assets/imagechoose/5.png',
                        'imagesmall' =>\ElementPress::widgets_url() . '/testimonial/assets/imagechoose/5.png',
                        'width' => '33.33%',
					],
					'style6' => [
						'title' => esc_html__( 'image style 6', 'elementpress' ),
                        'imagelarge' =>\ElementPress::widgets_url() . '/testimonial/assets/imagechoose/6.png',
                        'imagesmall' =>\ElementPress::widgets_url() . '/testimonial/assets/imagechoose/6.png',
                        'width' => '33.33%',
					],
				],
            ]
        );

		 $this->end_controls_section();
        $this->start_controls_section(
            'epress_testimonial_section_tab_style',
            [
                'label' => esc_html__('Testimonial', 'elementpress'),
            ]
        );

		// enable warter mark icon
		$this->add_control(
            'epress_testimonial_wartermark_enable',
            [
                'label' => esc_html__( 'Enable Quote Icon', 'elementpress' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'elementpress' ),
                'label_off' => esc_html__( 'No', 'elementpress' ),
                'return_value' => 'yes',
				'default' => 'no',
				'condition' => [
					'epress_testimonial_style' => ['style2', 'style4', 'style5', 'style6']
				]
            ]
		);

		$this->add_control(
            'epress_testimonial_wartermark',
            [
                'label' => esc_html__( 'Quote Icon', 'elementpress' ),
                'label_block' => true,
                'type' => Controls_Manager::ICON,
				'default' => 'icon icon-quote1',
                'condition' => [
					'epress_testimonial_wartermark_enable' => 'yes',
					'epress_testimonial_style' => ['style2', 'style4', 'style5', 'style6'],
				],
            ]
		);

		// water mark position
		$this->add_control(
			'epress_testimonial_wartermark_position',
			[
				'label' => esc_html__( 'Quote Icon Position', 'elementpress' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'top',
				'separator'    => 'before',
				'options' => [
					'top'  => esc_html__( 'Top', 'elementpress' ),
					'bottom' => esc_html__( 'Bottom', 'elementpress' ),
				],
				'condition' => [
					'epress_testimonial_wartermark_enable' => 'yes',
					'epress_testimonial_style' => ['style5']
				]
			]
		);

		$this->add_control(
			'epress_testimonial_wartermark_mask_show_badge',
			[
				'label' => esc_html__( 'Show Quote Icon Badge', 'elementpress' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'elementpress' ),
				'label_off' => esc_html__( 'Hide', 'elementpress' ),
				'return_value' => 'yes',
				'default' => 'no',
				'separator'    => 'before',
				'condition' => [
					'epress_testimonial_wartermark_enable' => 'yes',
					'epress_testimonial_style' => ['style6']
				]
			]
		);

		$this->add_control(
			'epress_testimonial_wartermark_custom_position',
			[
				'label' => __( 'Custom Position', 'elementpress' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'elementpress' ),
				'label_off' => __( 'Hide', 'elementpress' ),
				'return_value' => 'yes',
				'default' => 'no',
				'separator'    => 'before',
				'condition' => [
					'epress_testimonial_wartermark_enable' => 'yes',
				],
			]
		);

		$this->add_responsive_control(
			'epress_testimonial_wartermark_custom_position_offset_x',
			[
				'label' => __( 'Left', 'elementpress' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 300,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 10,
				],
				'selectors' => [
					'{{WRAPPER}} .epress_watermark_icon_custom_position' => 'left: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'epress_testimonial_wartermark_enable' => 'yes',
					'epress_testimonial_wartermark_custom_position' => 'yes',
				]
			]
		);

		$this->add_responsive_control(
			'epress_testimonial_wartermark_custom_position_offset_y',
			[
				'label' => __( 'top', 'elementpress' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 300,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 10,
				],
				'selectors' => [
					'{{WRAPPER}} .epress_watermark_icon_custom_position' => 'top: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'epress_testimonial_wartermark_enable' => 'yes',
					'epress_testimonial_wartermark_custom_position' => 'yes',
				]
			]
		);

		// enable rating
		$this->add_control(
            'epress_testimonial_rating_enable',
            [
                'label' => esc_html__( 'Enable Rating', 'elementpress' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'elementpress' ),
                'label_off' => esc_html__( 'No', 'elementpress' ),
                'return_value' => 'yes',
				'default' => 'yes',
				'separetor' => 'before',
				'condition' => [
					'epress_testimonial_style' => ['style3', 'style4', 'style5', 'style6']
				]
            ]
		);

		// enable title separetor
		$this->add_control(
            'epress_testimonial_title_separetor',
            [
                'label'     => esc_html__( 'Show Separator', 'elementpress' ),
                'type'      => Controls_Manager::SWITCHER,
                'label_on'  => esc_html__( 'Yes', 'elementpress' ),
                'label_off' => esc_html__( 'No', 'elementpress' ),
				'default'   => 'yes',
				'separator'    => 'before',
				'condition' => [
					'epress_testimonial_style' => ['style1', 'style2'],
				]
            ]
		);

		$repeater = new Repeater();
        $repeater->add_control(
            'client_name', [
                'label' => esc_html__('Client Name', 'elementpress'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('Testimonial #1', 'elementpress'),
				'label_block' => true,
				'dynamic' => [
					'active' => true,
				],
            ]
        );
        $repeater->add_control(
            'designation', [
                'label' => esc_html__('Designation', 'elementpress'),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => esc_html__('Designation', 'elementpress'),
				'dynamic' => [
					'active' => true,
				],
            ]
        );
        $repeater->add_control(
            'review', [
				'label' => esc_html__('Testimonial Review', 'elementpress'),
				'type' => Controls_Manager::TEXTAREA,
				'label_block' => true,
				'default' => esc_html__('Review Text', 'elementpress'),
				'dynamic' => [
					'active' => true,
				],
            ]
        );
        $repeater->add_control(
            'rating', [
				'label' => esc_html__('Testimonial Rating', 'elementpress'),
				'type' => Controls_Manager::SELECT,
				'default' => '5',
				'options'   => [
					'5'     => esc_html__( '5', 'elementpress' ),
					'4'     => esc_html__( '4', 'elementpress' ),
					'3'     => esc_html__( '3', 'elementpress' ),
					'2'     => esc_html__( '2', 'elementpress' ),
					'1'     => esc_html__( '1', 'elementpress' ),
				],
				'label_block' => true,
            ]
        );
        $repeater->add_control(
            'client_photo', [
				'label' => esc_html__('Big Image', 'elementpress'),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'label_block' => true,
				'dynamic' => [
					'active' => true,
				],
            ]
        );
        $repeater->add_control(
            'client_logo', [
				'label' => esc_html__('Small Image', 'elementpress'),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'label_block' => true,
				'dynamic' => [
					'active' => true,
				],
            ]
        );
        $repeater->add_control(
            'use_hover_logo', [
				'label' => esc_html__( 'Display different logo on hover?', 'elements-test' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'elements-test' ),
				'label_off' => esc_html__( 'No', 'elements-test' ),
				'default' => 'no',
				'separator' => 'before',				
            ]
        );
        $repeater->add_control(
            'client_logo_active', [
				'label' => esc_html__('Logo Active', 'elementpress'),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'label_block' => true,
				'condition' => ['use_hover_logo' => 'yes'],
				'dynamic' => [
					'active' => true,
				],
            ]
        );
		$repeater->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'epress_testimonial_background_group',
                'label' => esc_html__( 'Background', 'elementpress' ),
                'types' => [ 'classic'],
                'selector' => '{{WRAPPER}} {{CURRENT_ITEM}}',
            ]
        );
        $this->add_control(
            'epress_testimonial_data',
            [
                'label' => esc_html__('Testimonial', 'elementpress'),
                'type' => Controls_Manager::REPEATER,
                'default' => [
                    [ 'client_name' => esc_html__('Testimonial #1', 'elementpress') ],
                    [ 'client_name' => esc_html__('Testimonial #2', 'elementpress') ],
                    [ 'client_name' => esc_html__('Testimonial #3', 'elementpress') ],
                ],

                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ client_name }}}',
            ]
		);



		$this->end_controls_section();

		// setting section

        $this->start_controls_section(
            'epress_testimonial_layout_settings',
            [
                'label' => esc_html__( 'Settings', 'elementpress' ),
            ]
        );

		$this->add_responsive_control(
			'epress_testimonial_left_right_spacing',
			[
				'label' => esc_html__( 'Spacing Left Right', 'elementpress' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 50,
						'step' => 1,
					],
				],
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'desktop_default' => [
					'size' => 15,
					'unit' => 'px',
				],
				'tablet_default' => [
					'size' => 10,
					'unit' => 'px',
				],
				'mobile_default' => [
					'size' => 10,
					'unit' => 'px',
				],
				'default' => [
					'size' => 15,
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} .elementpress-testimonial-slider .slick-slide' => 'margin-right: {{SIZE}}{{UNIT}};margin-left: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'epress_testimonial_top_bottom_spacing',
			[
				'label' => __( 'Padding', 'elementpress' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .elementpress-testimonial-slider .slick-list' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'epress_testimonial_slidetoshow',
			[
				'label' => esc_html__( 'Slides To Show', 'elementpress' ),
				'type' =>  Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 20,
				'step' => 1,

				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'default' => 1,
			]
		);

        $this->add_responsive_control(
			'epress_testimonial_slidesToScroll',
			[
				'label' => esc_html__( 'Slides To Scroll', 'elementpress' ),
				'type' =>  Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 20,
				'step' => 1,
				'default' => 1,
			]
		);

        $this->add_control(
			'epress_testimonial_speed',
			[
				'label' => esc_html__( 'Speed', 'elementpress' ),
				'type' =>  Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 10000,
				'step' => 1,
				'default' => 1000,
			]
		);

		$this->add_control(
			'epress_testimonial_autoplay',
			[
				'label' => esc_html__( 'Autoplay', 'elementpress' ),
				'type' =>  Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'elementpress' ),
				'label_off' => esc_html__( 'No', 'elementpress' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

        $this->add_control(
			'epress_testimonial_show_arrow',
			[
				'label' => esc_html__( 'Show arrow', 'elementpress' ),
				'type' =>   Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'elementpress' ),
				'label_off' => esc_html__( 'No', 'elementpress' ),
				'return_value' => 'yes',
				'default' => '',
			]
        );

        $this->add_control(
			'epress_testimonial_show_dot',
			[
				'label' => esc_html__( 'Show dots', 'elementpress' ),
				'type' =>   Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'elementpress' ),
				'label_off' => esc_html__( 'No', 'elementpress' ),
				'return_value' => 'yes',
				'default' => '',
			]
		);

        $this->add_control(
			'epress_testimonial_left_arrow',
			[
				'label' => esc_html__( 'Left arrow Icon', 'elementpress' ),
                'type' => Controls_Manager::ICON,
                'default' => 'icon icon-left-arrow2',
                'condition' => [
                        'epress_testimonial_show_arrow' => 'yes',
                ]
			]
        );

        $this->add_control(
			'epress_testimonial_right_arrow',
			[
				'label' => esc_html__( 'Right arrow Icon', 'elementpress' ),
                'type' => Controls_Manager::ICON,
                'default' => 'icon icon-right-arrow2',
                'condition' => [
                    'epress_testimonial_show_arrow' => 'yes',
                ]
			]
		);

		$this->add_control(
            'epress_testimonial_pause_on_hover',
            [
                'label' => esc_html__( 'Pause on Hover', 'elementpress' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'elementpress' ),
                'label_off' => esc_html__( 'No', 'elementpress' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->end_controls_section();

		// layout controll style start
		 $this->start_controls_section(
		    'epress_testimonial_section_layout', [
			    'label'	 => esc_html__( 'Layout', 'elementpress' ),
			    'tab'	 => Controls_Manager::TAB_STYLE,
		    ]
	    );

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'epress_testimonial_layout_background',
				'label' => esc_html__( 'Background', 'elementpress' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .elementpress-tootltip-testimonial .elementpress-commentor-content, {{WRAPPER}} .elementpress-single-testimonial-slider, {{WRAPPER}} .elementpress-testimonial_card, {{WRAPPER}} .elementpress-tootltip-testimonial .elementpress-commentor-content::before',
			]
		);

		 $this->add_responsive_control(
            'epress_testimonial_layout_margin',
            [
                'label'         => esc_html__('Column Gap', 'elementpress'),
                'type'          => Controls_Manager::SLIDER,
                'size_units'    => ['px', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .elementpress-tootltip-testimonial .elementpress-commentor-content, {{WRAPPER}} .elementpress-single-testimonial-slider, {{WRAPPER}}  .elementpress-testimonial_card' => 'margin-left: {{SIZE}}{{UNIT}}; margin-right: {{SIZE}}{{UNIT}};',
                ],
            ]
        );


		 $this->add_responsive_control(
			'epress_testimonial_layout_padding',
			[
				'label' =>esc_html__( 'Padding', 'elementpress' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .elementpress-tootltip-testimonial .elementpress-commentor-content, {{WRAPPER}} .elementpress-single-testimonial-slider, {{WRAPPER}}  .elementpress-testimonial_card' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'epress_testimonial_client_parent_container_margin',
			[
				'label' => esc_html__( 'Margin', 'elementpress' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .elementpress-testimonial-slider-block-style' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [
					'epress_testimonial_style' => ['style4']
				]
			]
		);


		//  $this->add_responsive_control(
		// 	'epress_testimonial_layout_border_radius',
		// 	[
		// 		'label' =>esc_html__( 'Border Radius', 'elementpress' ),
		// 		'type' => Controls_Manager::DIMENSIONS,
		// 		'size_units' => [ 'px'],
		// 		'default' => [
		// 			'top' => '',
		// 			'right' => '',
		// 			'bottom' => '' ,
		// 			'left' => '',
		// 		],
		// 		'selectors' => [
		// 			'{{WRAPPER}} .elementpress-tootltip-testimonial .elementpress-commentor-content, {{WRAPPER}} .elementpress-single-testimonial-slider, {{WRAPPER}} .elementpress-testimonial_card' =>  'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
		// 		],
		// 	]
		// );

		$this->add_responsive_control(
			'epress_testimonial_layout_border_radius',
			[
				'label' => __( 'Border Radius', 'elementpress' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .elementpress-tootltip-testimonial .elementpress-commentor-content, {{WRAPPER}} .elementpress-single-testimonial-slider, {{WRAPPER}} .elementpress-testimonial_card' =>  'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
            Group_Control_Box_Shadow::get_type(), [
                'name'      => 'epress_testimonial_layout_shadow',
                'selector'  => '{{WRAPPER}} .elementpress-tootltip-testimonial .elementpress-commentor-content, {{WRAPPER}} .elementpress-single-testimonial-slider, {{WRAPPER}}  .elementpress-testimonial_card',
            ]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'epress_testimonial_layout_border',
				'label' => esc_html__( 'Border', 'elementpress' ),
				'selector' => '{{WRAPPER}} .elementpress-single-testimonial-slider',
			]
		);

		$this->add_control(
			'epress_testimonial_layout_active_hedaing',
			[
				'label' => esc_html__( 'Active', 'elementpress' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'epress_testimonial_layout_active_border_color',
			[
				'label' => esc_html__( 'Border Color', 'elementpress' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .elementpress-single-testimonial-slider:hover' => 'border-color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'epress_testimonial_layout_active_background',
				'label' => esc_html__( 'Background', 'elementpress' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .elementpress-single-testimonial-slider:before',
			]
		);


		$this->end_controls_section();

		$this->start_controls_section(
		    'epress_testimonial_section_wraper_style', [
			    'label'	 => esc_html__( 'Wraper content style', 'elementpress' ),
				'tab'	 => Controls_Manager::TAB_STYLE,
		    ]
		);

		$this->add_responsive_control(
			'epress_testimonial_section_wraper_vertical_alignment',
			[
				'label' =>esc_html__( 'Vertical Alignment', 'elementpress' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'flex-start'    => [
						'title' =>esc_html__( 'Top', 'elementpress' ),
						'icon' => 'fa fa-caret-up',
					],
					'center' => [
						'title' =>esc_html__( 'Center', 'elementpress' ),
						'icon' => 'fa fa-align-center',
					],
					'flex-end' => [
						'title' =>esc_html__( 'Bottom', 'elementpress' ),
						'icon' => 'fa fa-caret-down',
					],
				],
				'selectors' => [
                    '{{WRAPPER}} .elementkit-testimonial-col' => 'align-self: {{VALUE}};'
                ],
				'default' => 'center',
			]
		);

		$this->add_responsive_control(
			'epress_testimonial_section_wraper_horizontal_alignment',
			[
				'label' =>esc_html__( 'Horizontal Alignment', 'elementpress' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left'    => [
						'title' =>esc_html__( 'Left', 'elementpress' ),
						'icon' => 'fa fa-align-left',
					],
					'center' => [
						'title' =>esc_html__( 'Center', 'elementpress' ),
						'icon' => 'fa fa-align-center',
					],
					'right' => [
						'title' =>esc_html__( 'Right', 'elementpress' ),
						'icon' => 'fa fa-align-right',
					],
				],
				'selectors' => [
                    '{{WRAPPER}} .elementpress-commentor-content' => 'text-align: {{VALUE}};',
                    '{{WRAPPER}} .elementpress-testimonial_card' => 'text-align: {{VALUE}};'
                ],
				'default' => 'left',
			]
		);

		$this->add_responsive_control(
			'epress_testimonial_section_wraper_padding',
			[
				'label' => esc_html__( 'Padding', 'elementpress' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .elementpress-commentor-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		// description
		$this->start_controls_section(
			'epress_testimonial_content_description',
			[
				'label' => esc_html__( 'Description', 'elementpress' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'epress_testimonial_description_typography',
				'label' => esc_html__( 'Typography', 'elementpress' ),
				'scheme' => Scheme_Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .elementpress-single-testimonial-slider  .elementpress-commentor-content > p, {{WRAPPER}} .elementpress-testimonial_card .elementpress-commentor-coment',
			]
		);

		$this->add_responsive_control(
			'epress_testimonial_description_margin',
			[
				'label' => esc_html__( 'Margin', 'elementpress' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .elementpress-single-testimonial-slider  .elementpress-commentor-content > p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .elementpress-testimonial_card .elementpress-commentor-coment' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'epress_testimonial_description_color',
			[
				'label' => esc_html__( 'Color', 'elementpress' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .elementpress-single-testimonial-slider  .elementpress-commentor-content > p' => 'color: {{VALUE}}',
					'{{WRAPPER}} .elementpress-testimonial_card .elementpress-commentor-coment' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'epress_testimonial_description_active_option',
			[
				'label' => esc_html__( 'Active', 'elementpress' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'epress_testimonial_description_active_color',
			[
				'label' => esc_html__( 'Color', 'elementpress' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .elementpress-single-testimonial-slider:hover  .elementpress-commentor-content > p' => 'color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_section();

		// Testimonial Review Rating

	    $this->start_controls_section(
		    'epress_testimonial_section_testimonial_ratting_style', [
			    'label'	 => esc_html__( 'Rating', 'elementpress' ),
			    'tab'	 => Controls_Manager::TAB_STYLE,
				'condition' => [
					'epress_testimonial_style' => ['style3', 'style4', 'style5', 'style6'],
					'epress_testimonial_rating_enable' => 'yes'
				]
		    ]
	    );

	    // Testimonial Review ratting Color
	    $this->add_responsive_control(
		    'epress_testimonial_review_ratting_color', [
			    'label'		 =>esc_html__( 'Color', 'elementpress' ),
				'type'		 => Controls_Manager::COLOR,
				'default' => '#fec42d',
			    'selectors'	 => [
				    '{{WRAPPER}} .elementpress-stars > li > a' => 'color: {{VALUE}};'
			    ],
		    ]
	    );

		 $this->add_responsive_control(
            'epress_testimonial_review_ratting_font_size',
            [
                'label'         => esc_html__('Font Size', 'elementpress'),
                'type'          => Controls_Manager::SLIDER,
                'size_units'    => ['px', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .elementpress-stars > li > a' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
		);

		$this->add_responsive_control(
			'epress_testimonial_review_ratting_right_spacing',
			[
				'label' => esc_html__( 'Items Margin Right', 'elementpress' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 5,
				],
				'selectors' => [
					'{{WRAPPER}} .elementpress-stars > li:not(:last-child)' => 'margin-right: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'epress_testimonial_review_ratting_spacing',
			[
				'label' => esc_html__( 'Review Margin', 'elementpress' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .elementpress-stars' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

	    $this->end_controls_section();

		$this->start_controls_section(
		    'epress_testimonial_section_wathermark_style', [
			    'label'	 => esc_html__( 'Quote icon', 'elementpress' ),
				'tab'	 => Controls_Manager::TAB_STYLE,
				'condition' => [
					'epress_testimonial_wartermark_enable' => 'yes',
				]
		    ]
		);

		$this->start_controls_tabs(
            'epress_testimonial_client_watermark_color_tabs'
        );

        $this->start_controls_tab(
            'epress_testimonial_client_watermark_normal_color_tab',
            [
                'label' => esc_html__( 'Normal', 'elementpress' ),
            ]
		);

		// Testimonial wathermark Color
	    $this->add_responsive_control(
		    'epress_testimonial_section_wathermark_color', [
			    'label'		 =>esc_html__( 'color', 'elementpress' ),
			    'type'		 => Controls_Manager::COLOR,
			    'selectors'	 => [
				    '{{WRAPPER}} .elementpress-single-testimonial-slider .elementpress-watermark-icon > i' => 'color: {{VALUE}};',
				    '{{WRAPPER}} .elementpress-testimonial-slider-block-style .elementpress-commentor-content > i' => 'color: {{VALUE}};',
				    '{{WRAPPER}} .elementpress-testimonial-slider-block-style-two .elementpress-icon-content > i' => 'color: {{VALUE}};',
				    '{{WRAPPER}} .elementpress-testimonial-slider-block-style-three .elementpress-icon-content > i' => 'color: {{VALUE}};'
			    ],
		    ]
	    );

		$this->end_controls_tab();

        $this->start_controls_tab(
            'epress_testimonial_client_watermark_active_color_tab',
            [
                'label' => esc_html__( 'Hover', 'elementpress' ),
            ]
		);

		$this->add_responsive_control(
            'epress_testimonial_section_wathermark_active_color',
            [
                'label'      => esc_html__( 'Color', 'elementpress' ),
                'type'       => Controls_Manager::COLOR,
                'selectors'  => [
                    '{{WRAPPER}} .elementpress-single-testimonial-slider:hover .elementpress-watermark-icon > i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .elementpress-testimonial-slider-block-style .elementpress-commentor-content > i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .elementpress-testimonial-slider-block-style-two .elementpress-icon-content > i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .elementpress-testimonial-slider-block-style-three .elementpress-icon-content > i' => 'color: {{VALUE}};',
                ],
            ]
        );

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_control(
			'epress_testimonial_client_watermark_color_tab_end',
			[
				'type' => Controls_Manager::DIVIDER,
				'style' => 'thick',
			]
		);

	    // Testimonial wathermark font size
		$this->add_responsive_control(
			'epress_testimonial_section_wathermark_typography',
			[
				'label' => esc_html__( 'Font Size', 'elementpress' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 48,
				],
				'selectors' => [
					'{{WRAPPER}} .elementpress-watermark-icon > i' => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .elementpress-testimonial-slider-block-style .elementpress-commentor-content > i' => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .elementpress-testimonial-slider-block-style-two .elementpress-icon-content > i' => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .elementpress-testimonial-slider-block-style-three .elementpress-icon-content > i' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'epress_testimonial_section_wathermark_margin_bottom',
			[
				'label' => esc_html__( 'Margin Bottom', 'elementpress' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 23,
				],
				'selectors' => [
					'{{WRAPPER}} .elementpress-testimonial-slider-block-style .elementpress-commentor-content > i' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .elementpress-testimonial-slider-block-style-two .elementpress-icon-content > i' => 'margin-bottom: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .elementpress-testimonial-slider-block-style-three .elementpress-icon-content > i' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'epress_testimonial_section_wathermark_icon_padding',
			[
				'label' => __( 'Padding', 'elementpress' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .elementpress-commentor-content > i' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .elementpress-icon-content > i' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .elementpress-watermark-icon > i' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'epress_testimonial_section_wathermark_icon_badge_background',
				'label' => esc_html__( 'Background', 'elementpress' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .elementpress-commentor-content > i, {{WRAPPER}} .elementpress-icon-content > i,{{WRAPPER}} .elementpress-watermark-icon > i',
				'condition' => [
					'epress_testimonial_style!' => 'style6'
				]
			]
		);

		$this->add_responsive_control(
			'epress_testimonial_section_wathermark_icon_radius',
			[
				'label' => __( 'Border Radius', 'elementpress' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .elementpress-commentor-content > i' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .elementpress-icon-content > i' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .elementpress-watermark-icon > i' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [
					'epress_testimonial_style!' => 'style6'
				],
			]
		);

		$this->add_control(
			'epress_testimonial_section_wathermark_badge_devider',
			[
				'type' => Controls_Manager::DIVIDER,
				'style' => 'thick',
				'condition' => [
					'epress_testimonial_wartermark_mask_show_badge' => 'yes'
				]
			]
		);

		// watermark badge
		$this->add_responsive_control(
			'epress_testimonial_section_wathermark_badge_radius',
			[
				'label' => esc_html__( 'Border Radius', 'elementpress' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ '%' ],
				'range' => [
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 50,
				],
				'selectors' => [
					'{{WRAPPER}} .elementpress-testimonial-slider-block-style-three .elementpress-icon-content.commentor-badge::before' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'epress_testimonial_wartermark_mask_show_badge' => 'yes'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'epress_testimonial_section_wathermark_badge_background',
				'label' => esc_html__( 'Background', 'elementpress' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .elementpress-testimonial-slider-block-style-three .elementpress-icon-content.commentor-badge::before',
				'condition' => [
					'epress_testimonial_wartermark_mask_show_badge' => 'yes'
				]
			]
		);

		$this->end_controls_section();

		// title separetor
		$this->start_controls_section(
			'epress_testimonial_title_separetor_tab',
			[
				'label' => esc_html__( 'Title Separetor', 'elementpress' ),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'epress_testimonial_title_separetor' => 'yes'
				]
			]
		);

		$this->start_controls_tabs(
            'epress_testimonial_client_title_separetor_color_tabs'
        );

        $this->start_controls_tab(
            'epress_testimonial_client_title_separetor_normal_color_tab',
            [
                'label' => esc_html__( 'Normal', 'elementpress' ),
            ]
		);

		$this->add_responsive_control(
            'epress_testimonial_title_separator_color',
            [
                'label'      => esc_html__( 'Separator Color', 'elementpress' ),
                'type'       => Controls_Manager::COLOR,
                'selectors'  => [
                    '{{WRAPPER}} .elementpress-single-testimonial-slider .elementpress-border-hr' => 'background-color: {{VALUE}};',
                ],
            ]
        );

		$this->end_controls_tab();

        $this->start_controls_tab(
            'epress_testimonial_client_title_separetor_active_color_tab',
            [
                'label' => esc_html__( 'Hover', 'elementpress' ),
            ]
		);

		$this->add_responsive_control(
            'epress_testimonial_title_separator_active_color',
            [
                'label'      => esc_html__( 'Separator Color', 'elementpress' ),
                'type'       => Controls_Manager::COLOR,
                'selectors'  => [
                    '{{WRAPPER}} .elementpress-single-testimonial-slider:hover .elementpress-border-hr' => 'background-color: {{VALUE}};',
                ],
            ]
        );

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_control(
			'epress_testimonial_client_title_separetor_color_tab_end',
			[
				'type' => Controls_Manager::DIVIDER,
				'style' => 'thick',
			]
		);

        $this->add_responsive_control(
			'epress_testimonial_title_separator_width',
			[
				'label' => esc_html__( 'Width', 'elementpress' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'%' => [
						'min' => 0,
						'max' => 300,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 40,
				],
				'selectors' => [
					'{{WRAPPER}} .elementpress-single-testimonial-slider .elementpress-border-hr' => 'width: {{SIZE}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'epress_testimonial_title_separator_height',
			[
				'label' => esc_html__( 'Height', 'elementpress' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
                        'max' => 100,
                        'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 2,
				],
				'selectors' => [
					'{{WRAPPER}} .elementpress-single-testimonial-slider .elementpress-border-hr' => 'height: {{SIZE}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'epress_testimonial_title_separator_margin',
			[
				'label' => esc_html__( 'Margin', 'elementpress' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'selectors' => [
					'{{WRAPPER}} .elementpress-single-testimonial-slider .elementpress-border-hr' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
		);

		$this->end_controls_section();

		// client style
		$this->start_controls_section(
			'epress_testimonial_client_content_section',
			[
				'label' => esc_html__( 'Client', 'elementpress' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		// client name heading
		$this->add_control(
			'epress_testimonial_client_name_heading',
			[
				'label' => esc_html__( 'Client Name', 'elementpress' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);


		$this->start_controls_tabs(
            'epress_testimonial_client_name_color_tabs'
        );

        $this->start_controls_tab(
            'epress_testimonial_client_name_normal_color_tab',
            [
                'label' => esc_html__( 'Normal', 'elementpress' ),
            ]
		);

		// Client Name Color
		$this->add_responsive_control(
		    'epress_testimonial_client_name_normal_color', [
			    'label'		 =>esc_html__( 'Color', 'elementpress' ),
			    'type'		 => Controls_Manager::COLOR,
			    'selectors'	 => [
				    '{{WRAPPER}} .elementpress-profile-info .elementpress-author-name' => 'color: {{VALUE}};'
			    ],
		    ]
	    );

		$this->end_controls_tab();

        $this->start_controls_tab(
            'epress_testimonial_client_name_active_color_tab',
            [
                'label' => esc_html__( 'Hover', 'elementpress' ),
            ]
		);

		// Client Name Color
		$this->add_responsive_control(
		    'epress_testimonial_client_name_active_color', [
			    'label'		 =>esc_html__( 'Color', 'elementpress' ),
			    'type'		 => Controls_Manager::COLOR,
			    'selectors'	 => [
				    '{{WRAPPER}} .elementpress-single-testimonial-slider:hover .elementpress-author-name' => 'color: {{VALUE}};'
			    ],
		    ]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_control(
			'epress_testimonial_client_name_color_tab_end',
			[
				'type' => Controls_Manager::DIVIDER,
				'style' => 'thick',
			]
		);

        // Client name typography
	    $this->add_group_control(
		    Group_Control_Typography::get_type(), [
			    'name'		 => 'epress_testimonial_client_name_typography',
			    'selector'	 => '{{WRAPPER}} .elementpress-profile-info .elementpress-author-name',
		    ]
		);

		// client name margin bottom
		$this->add_responsive_control(
			'epress_testimonial_client_name_spacing_bottom',
			[
				'label' => esc_html__( 'Margin Bottom', 'elementpress' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 0,
				],
				'selectors' => [
					'{{WRAPPER}} .elementpress-profile-info .elementpress-author-name' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		// client designation heading
		$this->add_control(
			'epress_testimonial_client_designation_heading',
			[
				'label' => esc_html__( 'Client Designation', 'elementpress' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->start_controls_tabs(
            'epress_testimonial_client_designation_color_tabs'
        );

        $this->start_controls_tab(
            'epress_testimonial_client_designation_normal_color_tab',
            [
                'label' => esc_html__( 'Normal', 'elementpress' ),
            ]
		);

		// Designation Color
	    $this->add_responsive_control(
		    'epress_testimonial_designation_normal_color', [
			    'label'		 =>esc_html__( 'Color', 'elementpress' ),
			    'type'		 => Controls_Manager::COLOR,
			    'selectors'	 => [
				    '{{WRAPPER}} .elementpress-profile-info .elementpress-author-des' => 'color: {{VALUE}};'
			    ],
		    ]
	    );

		$this->end_controls_tab();

        $this->start_controls_tab(
            'epress_testimonial_client_designation_active_color_tab',
            [
                'label' => esc_html__( 'Hover', 'elementpress' ),
            ]
		);

		// Designation Color
	    $this->add_responsive_control(
		    'epress_testimonial_designation_active_color', [
			    'label'		 =>esc_html__( 'Color', 'elementpress' ),
			    'type'		 => Controls_Manager::COLOR,
			    'selectors'	 => [
				    '{{WRAPPER}} .elementpress-single-testimonial-slider:hover .elementpress-author-des' => 'color: {{VALUE}};'
			    ],
		    ]
	    );

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_control(
			'epress_testimonial_client_designation_color_tab_end',
			[
				'type' => Controls_Manager::DIVIDER,
				'style' => 'thick',
			]
		);

		$this->add_responsive_control(
			'epress_testimonial_client_spacing',
			[
				'label' => esc_html__( 'Margin', 'elementpress' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .elementpress-commentor-bio' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

	    // Designation typography
	    $this->add_group_control(
		    Group_Control_Typography::get_type(), [
			    'name'		 => 'epress_testimonial_designation_typography',
			    'selector'	 => '{{WRAPPER}} .elementpress-single-testimonial-slider .elementpress-author-des',
		    ]
		);

		// client logo heading
		$this->add_control(
			'epress_testimonial_client_logo_heading',
			[
				'label' => esc_html__( 'Client Logo', 'elementpress' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => [
					'epress_testimonial_style' => ['style1', 'style2']
				]
			]
		);

		// client logo margin bottom
		$this->add_responsive_control(
			'epress_testimonial_client_logo_margin_bottom',
			[
				'label' => esc_html__( 'Margin Bottom', 'elementpress' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 32,
				],
				'selectors' => [
					'{{WRAPPER}} .elementpress-commentor-content .elementpress-client_logo' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'epress_testimonial_style' => ['style1', 'style2']
				]
			]
		);

		// client image heading
		$this->add_control(
			'epress_testimonial_client_image_heading',
			[
				'label' => esc_html__( 'Client Image', 'elementpress' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => [
					'epress_testimonial_style' => ['style1', 'style4', 'style5', 'style6']
				]
			]
		);

		// client image overlay
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'epress_testimonial_client_image_background',
				'label' => esc_html__( 'Background', 'elementpress' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .elementpress-profile-image-card::before',
				'condition' => [
					'epress_testimonial_style' => ['style1']
				]
			]
		);

		$this->add_control(
			'epress_testimonial_client_area_alignment',
			[
				'label' =>esc_html__( 'Alignment', 'elementpress' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'client_left'    => [
						'title' =>esc_html__( 'Left', 'elementpress' ),
						'icon' => 'fa fa-align-left',
					],
					'client_center' => [
						'title' =>esc_html__( 'Center', 'elementpress' ),
						'icon' => 'fa fa-align-center',
					],
					'client_right' => [
						'title' =>esc_html__( 'Right', 'elementpress' ),
						'icon' => 'fa fa-align-right',
					],
				],
				'default' => 'client_center',
				'condition' => [
					'epress_testimonial_style' => ['style4', 'style5', 'style6']
				]
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'epress_testimonial_client_image_border',
				'label' => esc_html__( 'Border', 'elementpress' ),
				'selector' => '{{WRAPPER}} .elementpress-commentor-image > img',
				'condition' => [
					'epress_testimonial_style' => ['style4', 'style5', 'style6']
				]
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'epress_testimonial_client_image_box_shadow',
				'label' => esc_html__( 'Box Shadow', 'elementpress' ),
				'selector' => '{{WRAPPER}} .elementpress-commentor-image > img',
				'condition' => [
					'epress_testimonial_style' => ['style4', 'style5', 'style6']
				]
			]
		);

		$this->add_responsive_control(
			'epress_testimonial_client_image_margin_bottom',
			[
				'label' => esc_html__( 'Margin Bottom', 'elementpress' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 20,
				],
				'selectors' => [
					'{{WRAPPER}} .elementpress-commentor-bio .elementpress-commentor-image' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'epress_testimonial_style' => ['style4']
				]
			]
		);

		$this->add_responsive_control(
			'epress_testimonial_client_image_margin_right',
			[
				'label' => esc_html__( 'Margin Right', 'elementpress' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 20,
				],
				'selectors' => [
					'{{WRAPPER}} .elementpress-commentor-bio .elementpress-commentor-image' => 'margin-right: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'epress_testimonial_style' => ['style5']
				]
			]
		);

		$this->add_responsive_control(
            'epress_testimonial_client_image_size',
            [
                'label'   => esc_html__('Image Size', 'elementpress'),
				'type'    => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 300,
						'step' => 1,
					],
				],
                'default' => [
					'unit' => 'px',
                    'size' => 70,
				],
				'condition' => [
					'epress_testimonial_style' => ['style4', 'style5', 'style6']
				]
            ]
		);

		$this->add_responsive_control(
			'epress_testimonial_client_author_container_top',
			[
				'label' => esc_html__( 'Bottom', 'elementpress' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => -200,
						'max' => 200,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => -98,
				],
				'selectors' => [
					'{{WRAPPER}} .elementpress-commentor-bio' => 'bottom: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'epress_testimonial_style' => ['style4']
				]
			]
		);

		$this->end_controls_section();

		// dot style
		$this->start_controls_section(
			'epress_testimonial_client_dot_tab',
			[
				'label' => esc_html__( 'Dot', 'elementpress' ),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'epress_testimonial_show_dot' => 'yes'
				]
			]
		);

		$this->add_responsive_control(
			'epress_testimonial_client_dot_bottom',
			[
				'label' => esc_html__( 'Dot Top Spacing', 'elementpress' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => -100,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => -50,
				],
				'selectors' => [
					'{{WRAPPER}} .elementpress-testimonial-slider .slick-dots' => 'bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'epress_testimonial_client_dot_width',
			[
				'label' => esc_html__( 'Width', 'elementpress' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 8,
				],
				'selectors' => [
					'{{WRAPPER}} .elementpress-testimonial-slider .slick-dots li button' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'epress_testimonial_client_dot_height',
			[
				'label' => esc_html__( 'Height', 'elementpress' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 8,
				],
				'selectors' => [
					'{{WRAPPER}} .elementpress-testimonial-slider .slick-dots li button' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'epress_testimonial_client_dot_border_radius',
			[
				'label' => esc_html__( 'Border radius', 'elementpress' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .elementpress-testimonial-slider .slick-dots li button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'epress_testimonial_client_dot_spacing',
			[
				'label' => esc_html__( 'Margin right', 'elementpress' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 12,
				],
				'selectors' => [
					'{{WRAPPER}} .elementpress-testimonial-slider .slick-dots li:not(:last-child)' => 'margin-right: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'epress_testimonial_client_dot_background',
				'label' => esc_html__( 'Background', 'elementpress' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .elementpress-testimonial-slider .slick-dots li button',
			]
		);

		$this->add_control(
			'epress_testimonial_client_dot_active_heading',
			[
				'label' => esc_html__( 'Active', 'elementpress' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'epress_testimonial_client_dot_active_background',
				'label' => esc_html__( 'Background', 'elementpress' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .elementpress-testimonial-slider .slick-dots li.slick-active button',
			]
		);

		$this->add_responsive_control(
			'epress_testimonial_client_dot_active_width',
			[
				'label' => esc_html__( 'Width', 'elementpress' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 8,
				],
				'selectors' => [
					'{{WRAPPER}} .elementpress-testimonial-slider .slick-dots li.slick-active button' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'epress_testimonial_client_dot_active_height',
			[
				'label' => esc_html__( 'Height', 'elementpress' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 8,
				],
				'selectors' => [
					'{{WRAPPER}} .elementpress-testimonial-slider .slick-dots li.slick-active button' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'epress_testimonial_client_dot_active_scale',
			[
				'label' => esc_html__( 'Scale', 'elementpress' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => .5,
						'max' => 3,
						'step' => 0.1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 1.2,
				],
				'selectors' => [
					'{{WRAPPER}} .elementpress-testimonial-slider .slick-dots li.slick-active button' => 'transform: scale({{SIZE}});',
				],
			]
		);

		$this->end_controls_section();


		$this->start_controls_section(
			'epress_testimonial_nav_style_tab',
			[
				'label' => esc_html__( 'Nav', 'elementpress' ),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'epress_testimonial_show_arrow' => 'yes'
				]
			]
		);

		$this->add_responsive_control(
			'epress_testimonial_nav_font_size',
			[
				'label' => esc_html__( 'Font Size', 'elementpress' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 36,
				],
				'selectors' => [
					'{{WRAPPER}} .elementpress-testimonial-slider .slick-prev' => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .elementpress-testimonial-slider .slick-next' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'epress_testimonial_nav_right_icon',
			[
				'label' => esc_html__( 'Prev', 'elementpress' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ '%' ],
				'range' => [
					'%' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 0,
				],
				'selectors' => [
					'{{WRAPPER}} .elementpress-testimonial-slider .slick-prev' => 'left: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'epress_testimonial_nav_left_icon',
			[
				'label' => esc_html__( 'Next', 'elementpress' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ '%' ],
				'range' => [
					'%' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 0,
				],
				'selectors' => [
					'{{WRAPPER}} .elementpress-testimonial-slider .slick-next' => 'right: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'epress_testimonial_nav_border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'elementpress' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .elementpress-testimonial-slider .slick-prev' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .elementpress-testimonial-slider .slick-next' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'epress_testimonial_nav_width',
			[
				'label' => esc_html__( 'Width', 'elementpress' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 50,
				],
				'selectors' => [
					'{{WRAPPER}} .elementpress-testimonial-slider .slick-prev' => 'width: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .elementpress-testimonial-slider .slick-next' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'epress_testimonial_nav_height',
			[
				'label' => esc_html__( 'Height', 'elementpress' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 50,
				],
				'selectors' => [
					'{{WRAPPER}} .elementpress-testimonial-slider .slick-prev' => 'height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .elementpress-testimonial-slider .slick-next' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_responsive_control(
            'epress_testimonial_nav_vertical_align',
            [
                'label' => esc_html__( 'vertical_align', 'elementpress' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px','%' ],
                'range' => [
                    '%' => [
                        'min' => -500,
                        'max' => 500,
                    ],
                    'px' => [
                        'min' => -500,
                        'max' => 500,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementpress-testimonial-slider .slick-arrow' => ' -webkit-transform: translateY({{SIZE}}{{UNIT}}); -ms-transform: translateY({{SIZE}}{{UNIT}}); transform: translateY({{SIZE}}{{UNIT}});',
                ],
            ]
        );


        $this->start_controls_tabs(
            'epress_testimonial_nav_hover_normal_tabs'
        );

        $this->start_controls_tab(
            'epress_testimonial_nav_normal_tab',
            [
                'label' => esc_html__( 'Normal', 'elementpress' ),
            ]
		);

		$this->add_responsive_control(
			'epress_testimonial_nav_font_color_normal',
			[
				'label' => esc_html__( 'Color', 'elementpress' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#000000',
				'selectors' => [
					'{{WRAPPER}} .elementpress-testimonial-slider .slick-prev' => 'color: {{VALUE}}',
					'{{WRAPPER}} .elementpress-testimonial-slider .slick-next' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'epress_testimonial_nav_background_normal',
				'label' => esc_html__( 'Background', 'elementpress' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .elementpress-testimonial-slider .slick-prev, {{WRAPPER}} .elementpress-testimonial-slider .slick-next',
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'epress_testimonial_nav_box_shadow_normal',
				'label' => esc_html__( 'Box Shadow', 'elementpress' ),
				'selector' => '{{WRAPPER}} .elementpress-testimonial-slider .slick-prev, {{WRAPPER}} .elementpress-testimonial-slider .slick-next',
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'epress_testimonial_nav_border_normal',
				'label' => esc_html__( 'Border', 'elementpress' ),
				'selector' => '{{WRAPPER}} .elementpress-testimonial-slider .slick-prev, {{WRAPPER}} .elementpress-testimonial-slider .slick-next',
			]
		);

		$this->end_controls_tab();

        $this->start_controls_tab(
            'epress_testimonial_nav_hover_tab',
            [
                'label' => esc_html__( 'Hover', 'elementpress' ),
            ]
		);

		$this->add_responsive_control(
			'epress_testimonial_nav_font_color_hover',
			[
				'label' => esc_html__( 'Color', 'elementpress' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#000000',
				'selectors' => [
					'{{WRAPPER}} .elementpress-testimonial-slider .slick-prev:hover' => 'color: {{VALUE}}',
					'{{WRAPPER}} .elementpress-testimonial-slider .slick-next:hover' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'epress_testimonial_nav_background_hover',
				'label' => esc_html__( 'Background', 'elementpress' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .elementpress-testimonial-slider .slick-prev:hover, {{WRAPPER}} .elementpress-testimonial-slider .slick-next:hover',
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'epress_testimonial_nav_box_shadow_hover',
				'label' => esc_html__( 'Box Shadow', 'elementpress' ),
				'selector' => '{{WRAPPER}} .elementpress-testimonial-slider .slick-prev:hover, {{WRAPPER}} .elementpress-testimonial-slider .slick-next:hover',
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'epress_testimonial_nav_border_hover',
				'label' => esc_html__( 'Border', 'elementpress' ),
				'selector' => '{{WRAPPER}} .elementpress-testimonial-slider .slick-prev:hover, {{WRAPPER}} .elementpress-testimonial-slider .slick-next:hover',
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();
    }

    protected function render( ) {
        echo '<div class="epress-wid-con" >';
           //echo $this->render_raw();

		   $epress_testimonial_style='style1';
		   $testimonials = [];
		   $settings = $this->get_settings_for_display();
		   // echo "<pre>";
		   //  print_r($settings);
		   extract($settings);
   
   
		   $wrapper_data   = 	$epress_testimonial_slidetoshow != "" ? "data-slidestoshow='$epress_testimonial_slidetoshow' " : "";
			$wrapper_data  .= 	$epress_testimonial_slidetoshow_tablet != "" ? "data-slidestoshowtablet= '$epress_testimonial_slidetoshow_tablet' " : "";
		   $wrapper_data  .= 	$epress_testimonial_slidetoshow_mobile != "" ? "data-slidestoshowmobile= '$epress_testimonial_slidetoshow_mobile' " : "";
		   $wrapper_data  .= 	$epress_testimonial_slidesToScroll != "" ? "data-slidestoscroll= '$epress_testimonial_slidesToScroll' " : "";
		   $wrapper_data  .= 	$epress_testimonial_slidesToScroll_tablet != "" ? "data-slidesToScroll_tablet= '$epress_testimonial_slidesToScroll_tablet' " : "";
		   $wrapper_data  .= 	$epress_testimonial_slidesToScroll_mobile != "" ? "data-slidesToScroll_mobile= '$epress_testimonial_slidesToScroll_mobile' " : "";
		   $wrapper_data  .= 	$epress_testimonial_speed !="" ? "data-speed= '$epress_testimonial_speed' " : "";
		   $wrapper_data  .= 	$epress_testimonial_autoplay != "" ? "data-autoplay= '$epress_testimonial_autoplay' " : "";
		   $wrapper_data  .= 	$epress_testimonial_show_arrow != "" ? "data-show_arrow= '$epress_testimonial_show_arrow' " : "";
		   $wrapper_data  .= 	$epress_testimonial_show_dot != "" ? "data-show_dot= '$epress_testimonial_show_dot' " : "";
		   $wrapper_data  .= 	$epress_testimonial_left_arrow != "" ? "data-left_icon= '$epress_testimonial_left_arrow' " : "";
		   $wrapper_data  .= 	$epress_testimonial_right_arrow != "" ? "data-right_icon= '$epress_testimonial_right_arrow' " : "";
		   $wrapper_data  .= 	$epress_testimonial_pause_on_hover != "" ? "data-pause_on_hover= '$epress_testimonial_pause_on_hover' " : "";
   
   
   
		   $testimonials = isset($epress_testimonial_data) ? $epress_testimonial_data : [];
		   $style = isset($epress_testimonial_style) ? $epress_testimonial_style : 'style1';
		//    echo print_r($epress_testimonial_style,true);
		   switch ($epress_testimonial_style) {
			   case 'style1':
				   $wrapper_class = "elementpress-default-testimonial";
				   break;
			   default:
				   $wrapper_class = "elementpress-default-testimonial";
				   break;
		   }
		   if (is_array($testimonials) && !empty($testimonials)):
			  // echo \ElementPress::widgets_URL() . '/testimonial/style/'.$style.'.php';
			   require_once \ElementPress::widgets_dir() . 'testimonial/style/'.$style.'.php';
		  // echo '<pre>Array: '.print_r($data,true).'</pre><br>';
   
			endif; // end if check testimonila array





        echo '</div>';
    }

  

    protected function content_template() { }
}