<?php

namespace Elementor;

use \Elementor\Controls_Manager;


if (!defined('ABSPATH')) exit;

class Elementpress_Widget_postimage extends Widget_Base
{
    public $base;

    public function get_name()
    {
        return 'elementpress-postimage';
    }

    public function get_title()
    {
        return esc_html__('Post Images', 'elementpress');
    }

    public function get_icon()
    {
        return 'eicon-featured-image';
    }

    public function get_categories()
    {
        return ['elementpress_singlepost'];
    }

    //register controls
    protected function register_controls()
    {
        //single post images section
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Single Post Images', 'elementpress'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        //Image size control inside single post images section. (select box control)
        $this->add_control(
            'image_size',
            [
                'label' => __('Image Size', 'elementpress'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'thumbnail',
                'options' => [
                    'thumbnail' => __('Thumbnail (  150x150 )', 'elementpress'),
                    'medium' => __('Medium (  300x300 )', 'elementpress'),
                    'large' => __('Large (  1024x1024 )', 'elementpress'),
                    'Full' => __('Full ( Original Image Size )', 'elementpress'),
                ],
            ]
        );
        //Image align control inside single post images section. (Choose control)
        $this->add_control(
            'image_align',
            [
                'label' => __('Alignment', 'elementpress'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('Left', 'elementpress'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'elementpress'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __('Right', 'elementpress'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'left',
                'selectors' => [
                    '{{WRAPPER}} .post-image' => 'text-align: {{VALUE}};',
                ],
                'separator' => 'before',
            ]
        );
        $this->end_controls_section(); //end single post images section
        //Style section after single post images section
        $this->start_controls_section(
            'style_section',
            [
                'label' => __('Style', 'elementpress'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        //style section Image dimensions control
        $this->add_control(
            'img_size_custom',
            [
                'label' => __('Image Dimension', 'elementpress'),
                'type' => \Elementor\Controls_Manager::IMAGE_DIMENSIONS,
                'description' => __('Crop the original image size to any custom size. Set custom width or height to keep the original size ratio.', 'elementpress'),
                'default' => [
                    'width' => '',
                    'height' => '',
                ],
            ]
        );
        //border type control inside style section.
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'border',
                'label' => __('Border', 'elementpress'),
                'selector' => '{{WRAPPER}} .feature_image',
            ]
        );
        //border radius control inside style section.
        $this->add_responsive_control(
            'border_radius',
            [
                'label' => __('Border Radius', 'plugin-name'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .feature_image' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section(); //end style section.
    }

    //front end display function.
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $imagesize = $settings['image_size'];
        $current_page = sanitize_post($GLOBALS['wp_the_query']->get_queried_object());
        $image_url=\Elementor\Utils::get_placeholder_image_src();
        // echo "<pre>";
        // print_r($image_url);die;
// Get the page slug
        if (isset($current_page) && !empty($current_page)) {
            // Get the page slug
            $slug = $current_page->post_name;
        } else {
            $slug = '';
        }
        $args = array(
            // 'name' => $slug,
            'post_type' => 'post',
            'post_status' => 'publish',
            'numberposts' => 1
        );
        $my_posts = get_posts($args);
        // echo print_r($my_posts);die;
        foreach ($my_posts as $post) {
            ?>
            <div class="post-image"><!--Show post image based on above controls -->
                <?php
                
                $featured_img_url = get_the_post_thumbnail_url($post->ID, $imagesize);
                if(empty($featured_img_url)){
                    $featured_img_url=  $image_url;
                }
             
                // $alt = get_post_meta ($post->ID, '_wp_attachment_image_alt', true );
            //    echo  print_r($alt);die;
                /* link thumbnail to full size image for use with lightbox*/ ?>
                <a href="<?= esc_url($featured_img_url) ?>" rel="lightbox"><img alt= "" class="feature_image"
                                            style="width:<?= $settings['img_size_custom']['width'] ?>px;height:<?= $settings['img_size_custom']['height'] ?>px;"
                                                                               src="<?= esc_url($featured_img_url) ?>"></a>
            </div>
            <?php
        }
    }

    protected function content_template()
    {
    }
}