<?php
/**
 * @author : Jegtheme
 */
namespace EPRESS\Module\Block;

Class Block_37_Option extends BlockOptionAbstract
{
	protected $default_number_post = 6;
	protected $default_ajax_post = 4;

	public function get_module_name()
	{
		return esc_html__('ElementPress - Module 37', 'elementpress');
	}

	public function additional_style()
	{
		$this->options[] = array(
			'type'          => 'colorpicker',
			'param_name'    => 'title_color',
			'group'         => esc_html__('Design', 'elementpress'),
			'heading'       => esc_html__('Title Color', 'elementpress'),
			'description'   => esc_html__('This option will change your Title color.', 'elementpress'),
		);

		$this->options[] = array(
			'type'          => 'colorpicker',
			'param_name'    => 'accent_color',
			'group'         => esc_html__('Design', 'elementpress'),
			'heading'       => esc_html__('Accent Color & Link Hover', 'elementpress'),
			'description'   => esc_html__('This option will change your accent color.', 'elementpress'),
		);

		$this->options[] = array(
			'type'          => 'colorpicker',
			'param_name'    => 'alt_color',
			'group'         => esc_html__('Design', 'elementpress'),
			'heading'       => esc_html__('Meta Color', 'elementpress'),
			'description'   => esc_html__('This option will change your meta color.', 'elementpress'),
		);

		$this->options[] = array(
			'type'          => 'colorpicker',
			'param_name'    => 'block_background',
			'group'         => esc_html__('Design', 'elementpress'),
			'heading'       => esc_html__('Block Background', 'elementpress'),
			'description'   => esc_html__('This option will change your Block Background', 'elementpress'),
		);

		$this->options[] = array(
			'type'          => 'checkbox',
			'param_name'    => 'box_shadow',
			'group'         => esc_html__('Design', 'elementpress'),
			'heading'       => esc_html__('Box Shadow', 'elementpress'),
			'std'           => false
		);
	}

	public function set_typography_option( $instance ) {

		$instance->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'        => 'title_typography',
				'label'       => esc_html__( 'Title Typography', 'elementpress' ),
				'description' => esc_html__( 'Set typography for post title', 'elementpress' ),
				'selector'    => '{{WRAPPER}} .jeg_post_title > a',
			]
		);

		$instance->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'        => 'meta_typography',
				'label'       => esc_html__( 'Meta Typography', 'elementpress' ),
				'description' => esc_html__( 'Set typography for post meta', 'elementpress' ),
				'selector'    => '{{WRAPPER}} .jeg_post_meta, {{WRAPPER}} .jeg_post_meta .fa, {{WRAPPER}}.jeg_postblock .jeg_subcat_list > li > a:hover, {{WRAPPER}} .jeg_pl_md_card .jeg_post_category a, {{WRAPPER}}.jeg_postblock .jeg_subcat_list > li > a.current, {{WRAPPER}} .jeg_pl_md_5 .jeg_post_meta, {{WRAPPER}} .jeg_pl_md_5 .jeg_post_meta .fa, {{WRAPPER}} .jeg_post_category a',
			]
		);
	}
}
