<?php

/**
 * Store and work with icons lists 
 *
 * @copyright   Copyright (C) 2018, Echo Plugins
 */
class EPKB_Icons {

	const CATEGORIES_ICONS = 'epkb_categories_icons_images';
	const DEFAULT_CATEGORY_ICON_NAME = 'ep_font_icon_folder';
	const DEFAULT_CATEGORY_TYPE = 'font';   // OR 'image'
	const DEFAULT_CATEGORY_IMAGE_SIZE = 'full';
	const DEFAULT_CATEGORY_IMAGE_ID = 0;
	const DEFAULT_IMAGE_SLUG = 'img/demo-icons/icons/info-icon.png';
	const CATEGORY_ICON_USER_CHANGED_FLAG = 'epkb_category_icon_user_changed';

	public static function get_common_icons() {
		$common_kb_icons = array(
			'file-pdf-o'            => 'file-pdf-o',
			'file-text-o'           => 'file-text-o',
			'file-word-o'           => 'file-word-o',
			'file-excel-o'          => 'file-excel-o',

			'file-image-o'          => 'file-image-o',
			'file-zip-o'            => 'file-zip-o',
			'file-audio-o'          => 'file-audio-o',
			'file-video-o'          => 'file-video-o',

			'link'                  => 'link',
			'youtube-play'          => 'youtube-play',
			'download'              => 'download',
			'external-link'         => 'external-link',

			'file-code-o'           => 'file-code-o',
			'file-o'                => 'file-o',
			'Files O'               => 'files-o',
			'folder-open'           => 'folder-open',

		);

		return $common_kb_icons;
	}

	public static function get_other_icons() {

		$other_icons = array(
			'code'                  => 'code',
			'Clipboard'             => 'clipboard',
			'book'                  => 'book',
			'info-circle'           => 'info-circle',
			'question-circle'       => 'question-circle',
			'exclamation-circle'    => 'exclamation-circle',
			'database'              => 'database',
			'file-powerpoint-o'     => 'file-powerpoint-o',
			'image'                 => 'image',
			'lock'                  => 'lock',
			'print'                 => 'print',
			'user'                  => 'user',
			'glass'                 => 'glass',
			'music'                 => 'music',
			'search'                => 'search',
			'envelope-o'            => 'envelope-o',
			'heart'                 => 'heart',
			'star'                  => 'star',
			'star-o'                => 'star-o',
			'film'                  => 'film',
			'th-large'              => 'th-large',
			'th'                    => 'th',
			'th-list'               => 'th-list',
			'check'                 => 'check',
			'close'                 => 'close',
			'search-plus'           => 'search-plus',
			'search-minus'          => 'search-minus',
			'power-off'             => 'power-off',
			'signal'                => 'signal',
			'gear'                  => 'gear',
			'trash-o'               => 'trash-o',
			'home'                  => 'home',
			'clock-o'               => 'clock-o',
			'road'                  => 'road',
			'arrow-circle-o-down'   => 'arrow-circle-o-down',
			'arrow-circle-o-up'     => 'arrow-circle-o-up',
			'inbox'                 => 'inbox',
			'play-circle-o'         => 'play-circle-o',
			'rotate-right'          => 'rotate-right',
			'repeat'                => 'repeat',
			'refresh'               => 'refresh',
			'list-alt'              => 'list-alt',
			'flag'                  => 'flag',
			'headphones'            => 'headphones',
			'volume-off'            => 'volume-off',
			'volume-down'           => 'volume-down',
			'volume-up'             => 'volume-up',
			'qrcode'                => 'qrcode',
			'barcode'               => 'barcode',
			'tag'                   => 'tag',
			'tags'                  => 'tags',
			'bookmark'              => 'bookmark',
			'camera'                => 'camera',
			'font'                  => 'font',
			'bold'                  => 'bold',
			'italic'                => 'italic',
			'text-height'           => 'text-height',
			'text-width'            => 'text-width',
			'align-left'            => 'align-left',
			'align-center'          => 'align-center',
			'align-right'           => 'align-right',
			'align-justify'         => 'align-justify',
			'list'                  => 'list',
			'dedent'                => 'dedent',
			'outdent'               => 'outdent',
			'indent'                => 'indent',
			'video-camera'          => 'video-camera',
			'photo'                 => 'photo',
			'pencil'                => 'pencil',
			'map-marker'            => 'map-marker',
			'adjust'                => 'adjust',
			'tint'                  => 'tint',
			'edit'                  => 'edit',
			'pencil-square-o'       => 'pencil-square-o',
			'share-square-o'        => 'share-square-o',
			'check-square-o'        => 'check-square-o',
			'arrows'                => 'arrows',
			'step-backward'         => 'step-backward',
			'fast-backward'         => 'fast-backward',
			'backward'              => 'backward',
			'play'                  => 'play',
			'pause'                 => 'pause',
			'stop'                  => 'stop',
			'forward'               => 'forward',
			'fast-forward'          => 'fast-forward',
			'Step Forward'          => 'step-forward',
			'Eject'                 => 'eject',
			'Chevron Left'          => 'chevron-left',
			'Chevron Right'         => 'chevron-right',
			'Plus Circle'           => 'plus-circle',
			'Minus Circle'          => 'minus-circle',
			'Times Circle'          => 'times-circle',
			'Check Circle'          => 'check-circle',
			'Crosshairs'            => 'crosshairs',
			'Times Circle O'        => 'times-circle-o',
			'Check Circle O'        => 'check-circle-o',
			'Ban'                   => 'ban',
			'Arrow Left'            => 'arrow-left',
			'Arrow Right'           => 'arrow-right',
			'Arrow Up'              => 'arrow-up',
			'Arrow Down'            => 'arrow-down',
			'Share'                 => 'share',
			'Expand'                => 'expand',
			'Compress'              => 'compress',
			'Plus'                  => 'plus',
			'Minus'                 => 'minus',
			'Asterisk'              => 'asterisk',
			'Gift'                  => 'gift',
			'Leaf'                  => 'leaf',
			'Fire'                  => 'fire',
			'Eye'                   => 'eye',
			'Eye Slash'             => 'eye-slash',
			'Warning'               => 'warning',
			'Plane'                 => 'plane',
			'Calendar'              => 'calendar',
			'Random'                => 'random',
			'Comment'               => 'comment',
			'Magnet'                => 'magnet',
			'Chevron Up'            => 'chevron-up',
			'Chevron Down'          => 'chevron-down',
			'Retweet'               => 'retweet',
			'Shopping Cart'         => 'shopping-cart',
			'Folder'                => 'folder',
			'Arrow V'               => 'arrows-v',
			'Arrow H'               => 'arrows-h',
			'Bar Chart'             => 'bar-chart',
			'Twitter Square'        => 'twitter-square',
			'Facebook Square'       => 'facebook-square',
			'Camera Retro'          => 'camera-retro',
			'Key'                   => 'key',
			'Gears'                 => 'gears',
			'Comments'              => 'comments',
			'Thumbs O Up'           => 'thumbs-o-up',
			'Thumbs O Down'         => 'thumbs-o-down',
			'Star Half'             => 'star-half',
			'Heart O'               => 'heart-o',
			'Sign Out'              => 'sign-out',
			'Linkedin Square'       => 'linkedin-square',
			'Thumb Tack'            => 'thumb-tack',
			'Sign In'               => 'sign-in',
			'Trophy'                => 'trophy',
			'Github Square'         => 'github-square',
			'Upload'                => 'upload',
			'Lemon O'               => 'lemon-o',
			'Phone'                 => 'phone',
			'Square O'              => 'square-o',
			'Bookmark O'            => 'bookmark-o',
			'Phone Square'          => 'phone-square',
			'Twitter'               => 'twitter',
			'Facebook'              => 'facebook',
			'Github'                => 'github',
			'Unlock'                => 'unlock',
			'Credit Card'           => 'credit-card',
			'RSS'                   => 'rss',
			'HDD O'                 => 'hdd-o',
			'Bullhorn'              => 'bullhorn',
			'bell'                  => 'bell',
			'Certificate'           => 'certificate',
			'Hand O Right'          => 'hand-o-right',
			'Hand O Left'           => 'hand-o-left',
			'Hand O Up'             => 'hand-o-up',
			'Hand O Down'           => 'hand-o-down',
			'Arrow Circle Left'     => 'arrow-circle-left',
			'Arrow Circle Right'    => 'arrow-circle-right',
			'Arrow Circle Up'       => 'arrow-circle-up',
			'Arrow Circle Down'     => 'arrow-circle-down',
			'Globe'                 => 'globe',
			'Wrench'                => 'wrench',
			'Tasks'                 => 'tasks',
			'Filter'                => 'filter',
			'Briefcase'             => 'briefcase',
			'Arrows Alt'            => 'arrows-alt',
			'Group'                 => 'group',
			'Cload'                 => 'cloud',
			'Flask'                 => 'flask',
			'Scissors'              => 'scissors',
			'Paperclip'             => 'paperclip',
			'Save'                  => 'save',
			'Floppy O'              => 'floppy-o',
			'Square'                => 'square',
			'Navicon'               => 'navicon',
			'Bars'                  => 'bars',
			'List UL'               => 'list-ul',
			'List OL'               => 'list-ol',
			'Strikethrough'         => 'strikethrough',
			'Underline'             => 'underline',
			'Table'                 => 'table',
			'Magic'                 => 'magic',
			'Truck'                 => 'truck',
			'Pinterest'             => 'pinterest',
			'Pinterest Square'      => 'pinterest-square',
			'Google Plus Square'    => 'google-plus-square',
			'Google Plus'           => 'google-plus',
			'Money'                 => 'money',
			'Caret Left'            => 'caret-left',
			'Caret right'           => 'caret-right',
			'Columns'               => 'columns',
			'Unsorted'              => 'unsorted',
			'Sort'                  => 'sort',
			'Sort Desc'             => 'sort-desc',
			'Sort Asc'              => 'sort-asc',
			'Envelope'              => 'envelope',
			'LinkedIn'              => 'linkedin',
			'Rotate Left'           => 'rotate-left',
			'Legal'                 => 'legal',
			'Tachometer'            => 'tachometer',
			'Comment O'             => 'comment-o',
			'Comments O'            => 'comments-o',
			'Bolt'                  => 'bolt',
			'Sitemap'               => 'sitemap',
			'Umbrella'              => 'umbrella',
			'Lightbulb O'           => 'lightbulb-o',
			'Exchange'              => 'exchange',
			'Cloud Download'        => 'cloud-download',
			'Cloud Upload'          => 'cloud-upload',
			'User MD'               => 'user-md',
			'Stethoscope'           => 'stethoscope',
			'Suitcase'              => 'suitcase',
			'Bell O'                => 'bell-o',
			'Coffee'                => 'coffee',
			'Cutlery'               => 'cutlery',
			'Building O'            => 'building-o',
			'Hospital O'            => 'hospital-o',
			'Ambulance'             => 'ambulance',
			'Medkit'                => 'medkit',
			'Fighter Jet'           => 'fighter-jet',
			'Beer'                  => 'beer',
			'H Square'              => 'h-square',
			'Plus Square'           => 'plus-square',
			'Angle Double Left'     => 'angle-double-left',
			'Angle Double Right'    => 'angle-double-right',
			'Angle Double UP'       => 'angle-double-up',
			'Angle Double Down'     => 'angle-double-down',
			'Angle Left'            => 'angle-left',
			'Angle Right'           => 'angle-right',
			'Angle Up'              => 'angle-up',
			'Angle Down'            => 'angle-down',
			'Desktop'               => 'desktop',
			'Laptop'                => 'laptop',
			'Tablet'                => 'tablet',
			'Mobile'                => 'mobile',
			'Circle O'              => 'circle-o',
			'Quote Left'            => 'quote-left',
			'quote-right'           => 'quote-right',
			'spinner'               => 'spinner',
			'circle'                => 'circle',
			'reply'                 => 'reply',
			'github-alt'            => 'github-alt',
			'folder-o'              => 'folder-o',
			'folder-open-o'         => 'folder-open-o',
			'smile-o'               => 'smile-o',
			'frown-o'               => 'frown-o',
			'meh-o'                 => 'meh-o',
			'gamepad'               => 'gamepad',
			'keyboard-o'            => 'keyboard-o',
			'flag-o'                => 'flag-o',
			'flag-checkered'        => 'flag-checkered',
			'terminal'              => 'terminal',
			'mail-reply-all'        => 'mail-reply-all',
			'reply-all'             => 'reply-all',
			'star-half-empty'       => 'star-half-empty',
			'location-arrow'        => 'location-arrow',
			'crop'                  => 'crop',
			'code-fork'             => 'code-fork',
			'unlink'                => 'unlink',
			'question'              => 'question',
			'info'                  => 'info',
			'exclamation'           => 'exclamation',
			'superscript'           => 'superscript',
			'subscript'             => 'subscript',
			'eraser'                => 'eraser',
			'puzzle-piece'          => 'puzzle-piece',
			'microphone'            => 'microphone',
			'microphone-slash'      => 'microphone-slash',
			'shield'                => 'shield',
			'calendar-o'            => 'calendar-o',
			'fire-extinguisher'     => 'fire-extinguisher',
			'rocket'                => 'rocket',
			'maxcdn'                => 'maxcdn',
			'chevron-circle-left'   => 'chevron-circle-left',
			'chevron-circle-right'  => 'chevron-circle-right',
			'chevron-circle-up'     => 'chevron-circle-up',
			'chevron-circle-down'   => 'chevron-circle-down',
			'html5'                 => 'html5',
			'css3'                  => 'css3',
			'anchor'                => 'anchor',
			'unlock-alt'            => 'unlock-alt',
			'bullseye'              => 'bullseye',
			'ellipsis-h'            => 'ellipsis-h',
			'ellipsis-v'            => 'ellipsis-v',
			'rss-square'            => 'rss-square',
			'play-circle'           => 'play-circle',
			'ticket'                => 'ticket',
			'minus-square'          => 'minus-square',
			'minus-square-o'        => 'minus-square-o',
			'level-up'              => 'level-up',
			'level-down'            => 'level-down',
			'check-square'          => 'check-square',
			'pencil-square'         => 'pencil-square',
			'external-link-square'  => 'external-link-square',
			'share-square'          => 'share-square',
			'compass'               => 'compass',
			'toggle-down'           => 'toggle-down',
			'toggle-up'             => 'toggle-up',
			'toggle-right'          => 'toggle-right',
			'euro'                  => 'euro',
			'eur'                   => 'eur',
			'gbp'                   => 'gbp',
			'dollar'                => 'dollar',
			'rupee'                 => 'rupee',
			'inr'                   => 'inr',
			'cny'                   => 'cny',
			'rmb'                   => 'rmb',
			'yen'                   => 'yen',
			'jpy'                   => 'jpy',
			'ruble'                 => 'ruble',
			'rouble'                => 'rouble',
			'rub'                   => 'rub',
			'won'                   => 'won',
			'krw'                   => 'krw',
			'bitcoin'               => 'bitcoin',
			'btc'                   => 'btc',
			'file'                  => 'file',
			'file-text'             => 'file-text',
			'sort-alpha-asc'        => 'sort-alpha-asc',
			'sort-alpha-desc'       => 'sort-alpha-desc',
			'sort-amount-asc'       => 'sort-amount-asc',
			'sort-amount-desc'      => 'sort-amount-desc',
			'sort-numeric-asc'      => 'sort-numeric-asc',
			'sort-numeric-desc'     => 'sort-numeric-desc',
			'thumbs-up'             => 'thumbs-up',
			'thumbs-down'           => 'thumbs-down',
			'youtube-square'        => 'youtube-square',
			'youtube'               => 'youtube',
			'xing'                  => 'xing',
			'xing-square'           => 'xing-square',
			'dropbox'               => 'dropbox',
			'stack-overflow'        => 'stack-overflow',
			'instagram'             => 'instagram',
			'flickr'                => 'flickr',
			'adn'                   => 'adn',
			'bitbucket'             => 'bitbucket',
			'bitbucket-square'      => 'bitbucket-square',
			'tumblr'                => 'tumblr',
			'tumblr-square'         => 'tumblr-square',
			'long-arrow-down'       => 'long-arrow-down',
			'long-arrow-up'         => 'long-arrow-up',
			'long-arrow-left'       => 'long-arrow-left',
			'long-arrow-right'      => 'long-arrow-right',
			'apple'                 => 'apple',
			'windows'               => 'windows',
			'android'               => 'android',
			'linux'                 => 'linux',
			'dribbble'              => 'dribbble',
			'skype'                 => 'skype',
			'foursquare'            => 'foursquare',
			'trello'                => 'trello',
			'female'                => 'female',
			'male'                  => 'male',
			'gittip'                => 'gittip',
			'gratipay'              => 'gratipay',
			'sun-o'                 => 'sun-o',
			'moon-o'                => 'moon-o',
			'archive'               => 'archive',
			'bug'                   => 'bug',
			'vk'                    => 'vk',
			'weibo'                 => 'weibo',
			'renren'                => 'renren',
			'pagelines'             => 'pagelines',
			'stack-exchange'        => 'stack-exchange',
			'arrow-circle-o-right'  => 'arrow-circle-o-right',
			'arrow-circle-o-left'   => 'arrow-circle-o-left',
			'toggle-left'           => 'toggle-left',
			'dot-circle-o'          => 'dot-circle-o',
			'wheelchair'            => 'wheelchair',
			'vimeo-square'          => 'vimeo-square',
			'turkish-lira'          => 'turkish-lira',
			'try'                   => 'try',
			'plus-square-o'         => 'plus-square-o',
			'space-shuttle'         => 'space-shuttle',
			'slack'                 => 'slack',
			'envelope-square'       => 'envelope-square',
			'wordpress'             => 'wordpress',
			'openid'                => 'openid',
			'bank'                  => 'bank',
			'graduation-cap'        => 'graduation-cap',
			'yahoo'                 => 'yahoo',
			'google'                => 'google',
			'reddit'                => 'reddit',
			'reddit-square'         => 'reddit-square',
			'stumbleupon-circle'    => 'stumbleupon-circle',
			'stumbleupon'           => 'stumbleupon',
			'delicious'             => 'delicious',
			'digg'                  => 'digg',
			'pied-piper-pp'         => 'pied-piper-pp',
			'pied-piper-alt'        => 'pied-piper-alt',
			'drupal'                => 'drupal',
			'joomla'                => 'joomla',
			'language'              => 'language',
			'fax'                   => 'fax',
			'building'              => 'building',
			'child'                 => 'child',
			'paw'                   => 'paw',
			'spoon'                 => 'spoon',
			'cube'                  => 'cube',
			'cubes'                 => 'cubes',
			'behance'               => 'behance',
			'behance-square'        => 'behance-square',
			'steam'                 => 'steam',
			'steam-square'          => 'steam-square',
			'recycle'               => 'recycle',
			'car'                   => 'car',
			'cab'                   => 'cab',
			'taxi'                  => 'taxi',
			'tree'                  => 'tree',
			'spotify'               => 'spotify',
			'deviantart'            => 'deviantart',
			'soundcloud'            => 'soundcloud',
			'vine'                  => 'vine',
			'codepen'               => 'codepen',
			'jsfiddle'              => 'jsfiddle',
			'life-saver'            => 'life-saver',
			'circle-o-notch'        => 'circle-o-notch',
			'rebel'                 => 'rebel',
			'ge'                    => 'ge',
			'empire'                => 'empire',
			'git-square'            => 'git-square',
			'git'                   => 'git',
			'yc-square'             => 'yc-square',
			'hacker-news'           => 'hacker-news',
			'tencent-weibo'         => 'tencent-weibo',
			'qq'                    => 'qq',
			'wechat'                => 'wechat',
			'paper-plane'           => 'paper-plane',
			'paper-plane-o'         => 'paper-plane-o',
			'history'               => 'history',
			'circle-thin'           => 'circle-thin',
			'header'                => 'header',
			'paragraph'             => 'paragraph',
			'sliders'               => 'sliders',
			'share-alt'             => 'share-alt',
			'share-alt-square'      => 'share-alt-square',
			'bomb'                  => 'bomb',
			'soccer-ball-o'         => 'soccer-ball-o',
			'futbol-o'              => 'futbol-o',
			'tty'                   => 'tty',
			'binoculars'            => 'binoculars',
			'plug'                  => 'plug',
			'slideshare'            => 'slideshare',
			'twitch'                => 'twitch',
			'yelp'                  => 'yelp',
			'newspaper-o'           => 'newspaper-o',
			'wifi'                  => 'wifi',
			'calculator'            => 'calculator',
			'paypal'                => 'paypal',
			'google-wallet'         => 'google-wallet',
			'cc-visa'               => 'cc-visa',
			'cc-mastercard'         => 'cc-mastercard',
			'cc-discover'           => 'cc-discover',
			'cc-amex'               => 'cc-amex',
			'cc-paypal'             => 'cc-paypal',
			'cc-stripe'             => 'cc-stripe',
			'bell-slash'            => 'bell-slash',
			'bell-slash-o'          => 'bell-slash-o',
			'trash'                 => 'trash',
			'copyright'             => 'copyright',
			'at'                    => 'at',
			'eyedropper'            => 'eyedropper',
			'paint-brush'           => 'paint-brush',
			'birthday-cake'         => 'birthday-cake',
			'area-chart'            => 'area-chart',
			'pie-chart'             => 'pie-chart',
			'line-chart'            => 'line-chart',
			'lastfm'                => 'lastfm',
			'lastfm-square'         => 'lastfm-square',
			'toggle-off'            => 'toggle-off',
			'toggle-on'             => 'toggle-on',
			'bicycle'               => 'bicycle',
			'bus'                   => 'bus',
			'ioxhost'               => 'ioxhost',
			'angellist'             => 'angellist',
			'cc'                    => 'cc',
			'shekel'                => 'shekel',
			'sheqel'                => 'sheqel',
			'ils'                   => 'ils',
			'meanpath'              => 'meanpath',
			'buysellads'            => 'buysellads',
			'connectdevelop'        => 'connectdevelop',
			'dashcube'              => 'dashcube',
			'forumbee'              => 'forumbee',
			'leanpub'               => 'leanpub',
			'sellsy'                => 'sellsy',
			'shirtsinbulk'          => 'shirtsinbulk',
			'simplybuilt'           => 'simplybuilt',
			'skyatlas'              => 'skyatlas',
			'cart-plus'             => 'cart-plus',
			'cart-arrow-down'       => 'cart-arrow-down',
			'diamond'               => 'diamond',
			'ship'                  => 'ship',
			'user-secret'           => 'user-secret',
			'motorcycle'            => 'motorcycle',
			'street-view'           => 'street-view',
			'heartbeat'             => 'heartbeat',
			'venus'                 => 'venus',
			'mars'                  => 'mars',
			'mercury'               => 'mercury',
			'intersex'              => 'intersex',
			'transgender-alt'       => 'transgender-alt',
			'venus-double'          => 'venus-double',
			'mars-double'           => 'mars-double',
			'venus-mars'            => 'venus-mars',
			'mars-stroke'           => 'mars-stroke',
			'mars-stroke-v'         => 'mars-stroke-v',
			'mars-stroke-h'         => 'mars-stroke-h',
			'neuter'                => 'neuter',
			'genderless'            => 'genderless',
			'facebook-official'     => 'facebook-official',
			'pinterest-p'           => 'pinterest-p',
			'whatsapp'              => 'whatsapp',
			'server'                => 'server',
			'user-plus'             => 'user-plus',
			'user-times'            => 'user-times',
			'hotel'                 => 'hotel',
			'bed'                   => 'bed',
			'viacoin'               => 'viacoin',
			'train'                 => 'train',
			'subway'                => 'subway',
			'medium'                => 'medium',
			'yc'                    => 'yc',
			'optin-monster'         => 'optin-monster',
			'opencart'              => 'opencart',
			'expeditedssl'          => 'expeditedssl',
			'battery-full'          => 'battery-full',
			'battery-three-quarters' => 'battery-three-quarters',
			'battery-half'          => 'battery-half',
			'battery-quarter'       => 'battery-quarter',
			'battery-empty'         => 'battery-empty',
			'mouse-pointer'         => 'mouse-pointer',
			'i-cursor'              => 'i-cursor',
			'object-group'          => 'object-group',
			'object-ungroup'        => 'object-ungroup',
			'sticky-note'           => 'sticky-note',
			'sticky-note-o'         => 'sticky-note-o',
			'cc-jcb'                => 'cc-jcb',
			'cc-diners-club'        => 'cc-diners-club',
			'clone'                 => 'clone',
			'balance-scale'         => 'balance-scale',
			'hourglass-o'           => 'hourglass-o',
			'hourglass-start'       => 'hourglass-start',
			'hourglass-half'        => 'hourglass-half',
			'hourglass-end'         => 'hourglass-end',
			'hourglass'             => 'hourglass',
			'hand-rock-o'           => 'hand-rock-o',
			'hand-paper-o'          => 'hand-paper-o',
			'hand-scissors-o'       => 'hand-scissors-o',
			'hand-lizard-o'         => 'hand-lizard-o',
			'hand-spock-o'          => 'hand-spock-o',
			'hand-pointer-o'        => 'hand-pointer-o',
			'hand-peace-o'          => 'hand-peace-o',
			'trademark'             => 'trademark',
			'registered'            => 'registered',
			'creative-commons'      => 'creative-commons',
			'gg'                    => 'gg',
			'gg-circle'             => 'gg-circle',
			'tripadvisor'           => 'tripadvisor',
			'odnoklassniki'         => 'odnoklassniki',
			'odnoklassniki-square'  => 'odnoklassniki-square',
			'get-pocket'            => 'get-pocket',
			'wikipedia-w'           => 'wikipedia-w',
			'safari'                => 'safari',
			'chrome'                => 'chrome',
			'firefox'               => 'firefox',
			'opera'                 => 'opera',
			'internet-explorer'     => 'internet-explorer',
			'tv'                    => 'tv',
			'contao'                => 'contao',
			'500px'                 => '500px',
			'amazon'                => 'amazon',
			'calendar-plus-o'       => 'calendar-plus-o',
			'calendar-minus-o'      => 'calendar-minus-o',
			'calendar-times-o'      => 'calendar-times-o',
			'calendar-check-o'      => 'calendar-check-o',
			'industry'              => 'industry',
			'map-pin'               => 'map-pin',
			'map-signs'             => 'map-signs',
			'map-o'                 => 'map-o',
			'map'                   => 'map',
			'commenting'            => 'commenting',
			'commenting-o'          => 'commenting-o',
			'houzz'                 => 'houzz',
			'vimeo'                 => 'vimeo',
			'black-tie'             => 'black-tie',
			'fonticons'             => 'fonticons',
			'reddit-alien'          => 'reddit-alien',
			'edge'                  => 'edge',
			'credit-card-alt'       => 'credit-card-alt',
			'codiepie'              => 'codiepie',
			'modx'                  => 'modx',
			'fort-awesome'          => 'fort-awesome',
			'usb'                   => 'usb',
			'product-hunt'          => 'product-hunt',
			'mixcloud'              => 'mixcloud',
			'scribd'                => 'scribd',
			'pause-circle'          => 'pause-circle',
			'pause-circle-o'        => 'pause-circle-o',
			'stop-circle'           => 'stop-circle',
			'stop-circle-o'         => 'stop-circle-o',
			'shopping-bag'          => 'shopping-bag',
			'shopping-basket'       => 'shopping-basket',
			'hashtag'               => 'hashtag',
			'bluetooth'             => 'bluetooth',
			'bluetooth-b'           => 'bluetooth-b',
			'percent'               => 'percent',
			'gitlab'                => 'gitlab',
			'wpbeginner'            => 'wpbeginner',
			'wpforms'               => 'wpforms',
			'envira'                => 'envira',
			'universal-access'      => 'universal-access',
			'wheelchair-alt'        => 'wheelchair-alt',
			'question-circle-o'     => 'question-circle-o',
			'blind'                 => 'blind',
			'audio-description'     => 'audio-description',
			'volume-control-phone'  => 'volume-control-phone',
			'braille'               => 'braille',
			'assistive-listening-systems' => 'assistive-listening-systems',
			'american-sign-language-interpreting' => 'american-sign-language-interpreting',
			'hard-of-hearing'       => 'hard-of-hearing',
			'glide'                 => 'glide',
			'glide-g'               => 'glide-g',
			'sign-language'         => 'sign-language',
			'low-vision'            => 'low-vision',
			'viadeo'                => 'viadeo',
			'viadeo-square'         => 'viadeo-square',
			'snapchat'              => 'snapchat',
			'snapchat-ghost'        => 'snapchat-ghost',
			'snapchat-square'       => 'snapchat-square',
			'pied-piper'            => 'pied-piper',
			'first-order'           => 'first-order',
			'yoast'                 => 'yoast',
			'themeisle'             => 'themeisle',
			'google-plus-circle'    => 'google-plus-circle',
			'google-plus-official'  => 'google-plus-official',
			'font-awesome'          => 'font-awesome',
			'handshake-o'           => 'handshake-o',
			'envelope-open'         => 'envelope-open',
			'envelope-open-o'       => 'envelope-open-o',
			'linode'                => 'linode',
			'address-book'          => 'address-book',
			'address-book-o'        => 'address-book-o',
			'address-card'          => 'address-card',
			'address-card-o'        => 'address-card-o',
			'user-circle'           => 'user-circle',
			'user-circle-o'         => 'user-circle-o',
			'user-o'                => 'user-o',
			'id-badge'              => 'id-badge',
			'id-card'               => 'id-card',
			'id-card-o'             => 'id-card-o',
			'quora'                 => 'quora',
			'free-code-camp'        => 'free-code-camp',
			'telegram'              => 'telegram',
			'thermometer-full'      => 'thermometer-full',
			'thermometer-three-quarters' => 'thermometer-three-quarters',
			'thermometer-half'      => 'thermometer-half',
			'thermometer-quarter'   => 'thermometer-quarter',
			'thermometer-0'         => 'thermometer-0'       ,
			'thermometer-empty'     => 'thermometer-empty',
			'shower'                => 'shower',
			'bathtub'               => 'bathtub'       ,
			's15'                   => 's15'       ,
			'podcast'               => 'podcast',
			'window-maximize'       => 'window-maximize',
			'window-minimize'       => 'window-minimize',
			'window-restore'        => 'window-restore',
			'window-close'          => 'window-close',
			'window-close-o'        => 'window-close-o',
			'bandcamp'              => 'bandcamp',
			'grav'                  => 'grav',
			'etsy'                  => 'etsy',
			'imdb'                  => 'imdb',
			'ravelry'               => 'ravelry',
			'eercast'               => 'eercast',
			'microchip'             => 'microchip',
			'snowflake-o'           => 'snowflake-o',
			'superpowers'           => 'superpowers',
			'wpexplorer'            => 'wpexplorer',
			'meetup'                => 'meetup'
		);
		ksort($other_icons);

		return $other_icons;
	}

	public static function get_all_icons(){
		$all_icons = array(

			//Echo Custom Icons ( Value => Name )
			'ep_font_icon_none'                         => '-- No Icon --',
			'ep_font_icon_book'                         => 'Book',
			'ep_font_icon_brief_case'                   => 'Brief Case',
			'ep_font_icon_building'                     => 'Building',
			'ep_font_icon_clip_board'                   => 'Clip Board',
			'ep_font_icon_comment'                      => 'Comments',
			'ep_font_icon_credit_card'                  => 'Credit Card',
			'ep_font_icon_data_report'                  => 'Data Report',
			'ep_font_icon_document'                     => 'Document',
			'ep_font_icon_documents'                    => 'Documents',
			'ep_font_icon_external_link'                => 'External Link',
			'ep_font_icon_flow_chart'                   => 'Flow Chart',
			'ep_font_icon_folder'                       => 'Folder',
			'ep_font_icon_folder_add'                   => 'Folder Add',
			'ep_font_icon_folder_open'                  => 'Open Folder',
			'ep_font_icon_gear'                         => 'Gear',
			'ep_font_icon_gears'                        => 'Gears',
			'ep_font_icon_hour_glass'                   => 'Hour Glass',
			'ep_font_icon_house'                        => 'House',
			'ep_font_icon_info'                         => 'Info',
			'ep_font_icon_life_saver'                   => 'Life Saver',
			'ep_font_icon_light_bulb'                   => 'Light Bulb',
			'ep_font_icon_map'                          => 'Map',
			'ep_font_icon_money'                        => 'Money',
			'ep_font_icon_paperclip'                    => 'Paper Clip',
			'ep_font_icon_pencil'                       => 'Pencil',
			'ep_font_icon_people'                       => 'People',
			'ep_font_icon_person'                       => 'Person',
			'ep_font_icon_plus'                         => 'Plus',
			'ep_font_icon_question'                     => 'Question',
			'ep_font_icon_screen'                       => 'Screen',
			'ep_font_icon_screw_driver'                  => 'Screw Driver',
			'ep_font_icon_shopping_cart'                => 'Shopping Cart',
			'ep_font_icon_tag'                          => 'Tag',
			'ep_font_icon_tools'                        => 'Tools',
			'ep_font_icon_wrench'                       => 'Wrench',
			'ep_font_icon_empty_star'                   => 'Empty Star',
			'ep_font_icon_full_star'                    => 'Full Star',
			'ep_font_icon_half_star'                    => 'Half Star',
			'ep_font_icon_plus_box'                     => 'Plus Box',
			'ep_font_icon_minus'                        => 'Minus',
			'ep_font_icon_minus_box'                    => 'Minus Box',
			'ep_font_icon_up_arrow'                     => 'Up Arrow',
			'ep_font_icon_down_arrow'                   => 'Down Arrow',
			'ep_font_icon_right_arrow'                  => 'Right Arrow',
			'ep_font_icon_left_arrow'                   => 'Left Arrow',
			'ep_font_icon_error_circle'                 => 'Error Circle',
			'ep_font_icon_error_oct'                    => 'Error Octagon',
			'ep_font_icon_error_triangle'               => 'Error Triangle',
			'ep_font_icon_arrow_carrot_up_circle'       => 'Arrow Up Circle',
			'ep_font_icon_arrow_carrot_right_circle'    => 'Arrow Right Circle',
			'ep_font_icon_arrow_carrot_down_circle'     => 'Arrow Down Circle',
			'ep_font_icon_arrow_carrot_left_circle'     => 'Arrow Left Circle',
			'ep_font_icon_arrow_carrot_left'            => 'Arrow Caret Left',
			'ep_font_icon_arrow_carrot_right'           => 'Arrow Caret Right',
			'ep_font_icon_arrow_carrot_up'              => 'Arrow Caret Up',
			'ep_font_icon_arrow_carrot_down'            => 'Arrow Caret Down',

			//Font Awesome Icons	( Value => Name )
			'fa-file-pdf-o'            => 'fa-file-pdf-o',
			'fa-file-text-o'           => 'fa-file-text-o',
			'fa-file-word-o'           => 'fa-file-word-o',
			'fa-file-excel-o'          => 'fa-file-excel-o',
			'fa-file-image-o'          => 'fa-file-image-o',
			'fa-file-zip-o'            => 'fa-file-zip-o',
			'fa-file-audio-o'          => 'fa-file-audio-o',
			'fa-file-video-o'          => 'fa-file-video-o',
			'fa-link'                  => 'fa-link',
			'fa-youtube-play'          => 'fa-youtube-play',
			'fa-download'              => 'fa-download',
			'fa-external-link'         => 'fa-external-link',
			'fa-file-code-o'           => 'fa-file-code-o',
			'fa-file-o'                => 'fa-file-o',
			'fa-files-o'               => 'fa-files-o',
			'fa-folder-open'           => 'fa-folder-open',
			'fa-code'                  => 'fa-code',
			'fa-clipboard'             => 'fa-clipboard',
			'fa-book'                  => 'fa-book',
			'fa-info-circle'           => 'fa-info-circle',
			'fa-question-circle'       => 'fa-question-circle',
			'fa-exclamation-circle'    => 'fa-exclamation-circle',
			'fa-database'              => 'fa-database',
			'fa-file-powerpoint-o'     => 'fa-file-powerpoint-o',
			'fa-image'                 => 'fa-image',
			'fa-lock'                  => 'fa-lock',
			'fa-print'                 => 'fa-print',
			'fa-user'                  => 'fa-user',
			'fa-glass'                 => 'fa-glass',
			'fa-music'                 => 'fa-music',
			'fa-search'                => 'fa-search',
			'fa-envelope-o'            => 'fa-envelope-o',
			'fa-heart'                 => 'fa-heart',
			'fa-star'                  => 'fa-star',
			'fa-star-o'                => 'fa-star-o',
			'fa-film'                  => 'fa-film',
			'fa-th-large'              => 'fa-th-large',
			'fa-th'                    => 'fa-th',
			'fa-th-list'               => 'fa-th-list',
			'fa-check'                 => 'fa-check',
			'fa-close'                 => 'fa-close',
			'fa-search-plus'           => 'fa-search-plus',
			'fa-search-minus'          => 'fa-search-minus',
			'fa-power-off'             => 'fa-power-off',
			'fa-signal'                => 'fa-signal',
			'fa-gear'                  => 'fa-gear',
			'fa-trash-o'               => 'fa-trash-o',
			'fa-home'                  => 'fa-home',
			'fa-clock-o'               => 'fa-clock-o',
			'fa-road'                  => 'fa-road',
			'fa-arrow-circle-o-down'   => 'fa-arrow-circle-o-down',
			'fa-arrow-circle-o-up'     => 'fa-arrow-circle-o-up',
			'fa-inbox'                 => 'fa-inbox',
			'fa-play-circle-o'         => 'fa-play-circle-o',
			'fa-rotate-right'          => 'fa-rotate-right',
			'fa-repeat'                => 'fa-repeat',
			'fa-refresh'               => 'fa-refresh',
			'fa-list-alt'              => 'fa-list-alt',
			'fa-flag'                  => 'fa-flag',
			'fa-headphones'            => 'fa-headphones',
			'fa-volume-off'            => 'fa-volume-off',
			'fa-volume-down'           => 'fa-volume-down',
			'fa-volume-up'             => 'fa-volume-up',
			'fa-qrcode'                => 'fa-qrcode',
			'fa-barcode'               => 'fa-barcode',
			'fa-tag'                   => 'fa-tag',
			'fa-tags'                  => 'fa-tags',
			'fa-bookmark'              => 'fa-bookmark',
			'fa-camera'                => 'fa-camera',
			'fa-font'                  => 'fa-font',
			'fa-bold'                  => 'fa-bold',
			'fa-italic'                => 'fa-italic',
			'fa-text-height'           => 'fa-text-height',
			'fa-text-width'            => 'fa-text-width',
			'fa-align-left'            => 'fa-align-left',
			'fa-align-center'          => 'fa-align-center',
			'fa-align-right'           => 'fa-align-right',
			'fa-align-justify'         => 'fa-align-justify',
			'fa-list'                  => 'fa-list',
			'fa-dedent'                => 'fa-dedent',
			'fa-outdent'               => 'fa-outdent',
			'fa-indent'                => 'fa-indent',
			'fa-video-camera'          => 'fa-video-camera',
			'fa-photo'                 => 'fa-photo',
			'fa-pencil'                => 'fa-pencil',
			'fa-map-marker'            => 'fa-map-marker',
			'fa-adjust'                => 'fa-adjust',
			'fa-tint'                  => 'fa-tint',
			'fa-edit'                  => 'fa-edit',
			'fa-pencil-square-o'       => 'fa-pencil-square-o',
			'fa-share-square-o'        => 'fa-share-square-o',
			'fa-check-square-o'        => 'fa-check-square-o',
			'fa-arrows'                => 'fa-arrows',
			'fa-step-backward'         => 'fa-step-backward',
			'fa-fast-backward'         => 'fa-fast-backward',
			'fa-backward'              => 'fa-backward',
			'fa-play'                  => 'fa-play',
			'fa-pause'                 => 'fa-pause',
			'fa-stop'                  => 'fa-stop',
			'fa-forward'               => 'fa-forward',
			'fa-fast-forward'          => 'fa-fast-forward',
			'fa-step-forward'          => 'fa-step-forward',
			'fa-eject'                 => 'fa-eject',
			'fa-chevron-left'          => 'fa-chevron-left',
			'fa-chevron-right'         => 'fa-chevron-right',
			'fa-plus-circle'           => 'fa-plus-circle',
			'fa-minus-circle'          => 'fa-minus-circle',
			'fa-times-circle'          => 'fa-times-circle',
			'fa-check-circle'          => 'fa-check-circle',
			'fa-crosshairs'            => 'fa-crosshairs',
			'fa-times-circle-o'        => 'fa-times-circle-o',
			'fa-check-circle-o'        => 'fa-check-circle-o',
			'fa-ban'                   => 'fa-ban',
			'fa-arrow-left'            => 'fa-arrow-left',
			'fa-arrow-right'           => 'fa-arrow-right',
			'fa-arrow-up'              => 'fa-arrow-up',
			'fa-arrow-down'            => 'fa-arrow-down',
			'fa-share'                 => 'fa-share',
			'fa-expand'                => 'fa-expand',
			'fa-compress'              => 'fa-compress',
			'fa-plus'                  => 'fa-plus',
			'fa-minus'                 => 'fa-minus',
			'fa-asterisk'              => 'fa-asterisk',
			'fa-gift'                  => 'fa-gift',
			'fa-leaf'                  => 'fa-leaf',
			'fa-fire'                  => 'fa-fire',
			'fa-eye'                   => 'fa-eye',
			'fa-eye-slash'             => 'fa-eye-slash',
			'fa-warning'               => 'fa-warning',
			'fa-plane'                 => 'fa-plane',
			'fa-calendar'              => 'fa-calendar',
			'fa-random'                => 'fa-random',
			'fa-comment'               => 'fa-comment',
			'fa-magnet'                => 'fa-magnet',
			'fa-chevron-up'            => 'fa-chevron-up',
			'fa-chevron-down'          => 'fa-chevron-down',
			'fa-retweet'               => 'fa-retweet',
			'fa-shopping-cart'         => 'fa-shopping-cart',
			'fa-folder'                => 'fa-folder',
			'fa-arrows-v'              => 'fa-arrows-v',
			'fa-arrows-h'              => 'fa-arrows-h',
			'fa-bar-chart'             => 'fa-bar-chart',
			'fa-twitter-square'        => 'fa-twitter-square',
			'fa-facebook-square'       => 'fa-facebook-square',
			'fa-camera-retro'          => 'fa-camera-retro',
			'fa-key'                   => 'fa-key',
			'fa-gears'                 => 'fa-gears',
			'fa-comments'              => 'fa-comments',
			'fa-thumbs-o-up'           => 'fa-thumbs-o-up',
			'fa-thumbs-o-down'         => 'fa-thumbs-o-down',
			'fa-star-half'             => 'fa-star-half',
			'fa-heart-o'               => 'fa-heart-o',
			'fa-sign-out'              => 'fa-sign-out',
			'fa-linkedin-square'       => 'fa-linkedin-square',
			'fa-thumb-tack'            => 'fa-thumb-tack',
			'fa-sign-in'               => 'fa-sign-in',
			'fa-trophy'                => 'fa-trophy',
			'fa-github-square'         => 'fa-github-square',
			'fa-upload'                => 'fa-upload',
			'fa-lemon-o'               => 'fa-lemon-o',
			'fa-phone'                 => 'fa-phone',
			'fa-square-o'              => 'fa-square-o',
			'fa-bookmark-o'            => 'fa-bookmark-o',
			'fa-phone-square'          => 'fa-phone-square',
			'fa-twitter'               => 'fa-twitter',
			'fa-facebook'              => 'fa-facebook',
			'fa-github'                => 'fa-github',
			'fa-unlock'                => 'fa-unlock',
			'fa-credit-card'           => 'fa-credit-card',
			'fa-rss'                   => 'fa-rss',
			'fa-hdd-o'                 => 'fa-hdd-o',
			'fa-bullhorn'              => 'fa-bullhorn',
			'fa-bell'                  => 'fa-bell',
			'fa-certificate'           => 'fa-certificate',
			'fa-hand-o-right'          => 'fa-hand-o-right',
			'fa-hand-o-left'           => 'fa-hand-o-left',
			'fa-hand-o-up'             => 'fa-hand-o-up',
			'fa-hand-o-down'           => 'fa-hand-o-down',
			'fa-arrow-circle-left'     => 'fa-arrow-circle-left',
			'fa-arrow-circle-right'    => 'fa-arrow-circle-right',
			'fa-arrow-circle-up'       => 'fa-arrow-circle-up',
			'fa-arrow-circle-down'     => 'fa-arrow-circle-down',
			'fa-globe'                 => 'fa-globe',
			'fa-wrench'                => 'fa-wrench',
			'fa-tasks'                 => 'fa-tasks',
			'fa-filter'                => 'fa-filter',
			'fa-briefcase'             => 'fa-briefcase',
			'fa-arrows-alt'            => 'fa-arrows-alt',
			'fa-group'                 => 'fa-group',
			'fa-cloud'                 => 'fa-cloud',
			'fa-flask'                 => 'fa-flask',
			'fa-scissors'              => 'fa-scissors',
			'fa-paperclip'             => 'fa-paperclip',
			'fa-save'                  => 'fa-save',
			'fa-floppy-o'              => 'fa-floppy-o',
			'fa-square'                => 'fa-square',
			'fa-navicon'               => 'fa-navicon',
			'fa-bars'                  => 'fa-bars',
			'fa-list-ul'               => 'fa-list-ul',
			'fa-list-ol'               => 'fa-list-ol',
			'fa-strikethrough'         => 'fa-strikethrough',
			'fa-underline'             => 'fa-underline',
			'fa-table'                 => 'fa-table',
			'fa-magic'                 => 'fa-magic',
			'fa-truck'                 => 'fa-truck',
			'fa-pinterest'             => 'fa-pinterest',
			'fa-pinterest-square'      => 'fa-pinterest-square',
			'fa-google-plus-square'    => 'fa-google-plus-square',
			'fa-google-plus'           => 'fa-google-plus',
			'fa-money'                 => 'fa-money',
			'fa-caret-left'            => 'fa-caret-left',
			'fa-caret-right'           => 'fa-caret-right',
			'fa-columns'               => 'fa-columns',
			'fa-unsorted'              => 'fa-unsorted',
			'fa-sort'                  => 'fa-sort',
			'fa-sort-desc'             => 'fa-sort-desc',
			'fa-sort-asc'              => 'fa-sort-asc',
			'fa-envelope'              => 'fa-envelope',
			'fa-linkedin'              => 'fa-linkedin',
			'fa-rotate-left'           => 'fa-rotate-left',
			'fa-legal'                 => 'fa-legal',
			'fa-tachometer'            => 'fa-tachometer',
			'fa-comment-o'             => 'fa-comment-o',
			'fa-comments-o'            => 'fa-comments-o',
			'fa-bolt'                  => 'fa-bolt',
			'fa-sitemap'               => 'fa-sitemap',
			'fa-umbrella'              => 'fa-umbrella',
			'fa-lightbulb-o'           => 'fa-lightbulb-o',
			'fa-exchange'              => 'fa-exchange',
			'fa-cloud-download'        => 'fa-cloud-download',
			'fa-cloud-upload'          => 'fa-cloud-upload',
			'fa-user-md'               => 'fa-user-md',
			'fa-stethoscope'           => 'fa-stethoscope',
			'fa-suitcase'              => 'fa-suitcase',
			'fa-bell-o'                => 'fa-bell-o',
			'fa-coffee'                => 'fa-coffee',
			'fa-cutlery'               => 'fa-cutlery',
			'fa-building-o'            => 'fa-building-o',
			'fa-hospital-o'            => 'fa-hospital-o',
			'fa-ambulance'             => 'fa-ambulance',
			'fa-medkit'                => 'fa-medkit',
			'fa-fighter-jet'           => 'fa-fighter-jet',
			'fa-beer'                  => 'fa-beer',
			'fa-h-square'              => 'fa-h-square',
			'fa-plus-square'           => 'fa-plus-square',
			'fa-angle-double-left'     => 'fa-angle-double-left',
			'fa-angle-double-right'    => 'fa-angle-double-right',
			'fa-angle-double-up'       => 'fa-angle-double-up',
			'fa-angle-double-down'     => 'fa-angle-double-down',
			'fa-angle-left'            => 'fa-angle-left',
			'fa-angle-right'           => 'fa-angle-right',
			'fa-angle-up'              => 'fa-angle-up',
			'fa-angle-down'            => 'fa-angle-down',
			'fa-desktop'               => 'fa-desktop',
			'fa-laptop'                => 'fa-laptop',
			'fa-tablet'                => 'fa-tablet',
			'fa-mobile'                => 'fa-mobile',
			'fa-circle-o'              => 'fa-circle-o',
			'fa-quote-left'            => 'fa-quote-left',
			'fa-quote-right'           => 'fa-quote-right',
			'fa-spinner'               => 'fa-spinner',
			'fa-circle'                => 'fa-circle',
			'fa-reply'                 => 'fa-reply',
			'fa-github-alt'            => 'fa-github-alt',
			'fa-folder-o'              => 'fa-folder-o',
			'fa-folder-open-o'         => 'fa-folder-open-o',
			'fa-smile-o'               => 'fa-smile-o',
			'fa-frown-o'               => 'fa-frown-o',
			'fa-meh-o'                 => 'fa-meh-o',
			'fa-gamepad'               => 'fa-gamepad',
			'fa-keyboard-o'            => 'fa-keyboard-o',
			'fa-flag-o'                => 'fa-flag-o',
			'fa-flag-checkered'        => 'fa-flag-checkered',
			'fa-terminal'              => 'fa-terminal',
			'fa-mail-reply-all'        => 'fa-mail-reply-all',
			'fa-reply-all'             => 'fa-reply-all',
			'fa-star-half-empty'       => 'fa-star-half-empty',
			'fa-location-arrow'        => 'fa-location-arrow',
			'fa-crop'                  => 'fa-crop',
			'fa-code-fork'             => 'fa-code-fork',
			'fa-unlink'                => 'fa-unlink',
			'fa-question'              => 'fa-question',
			'fa-info'                  => 'fa-info',
			'fa-exclamation'           => 'fa-exclamation',
			'fa-superscript'           => 'fa-superscript',
			'fa-subscript'             => 'fa-subscript',
			'fa-eraser'                => 'fa-eraser',
			'fa-puzzle-piece'          => 'fa-puzzle-piece',
			'fa-microphone'            => 'fa-microphone',
			'fa-microphone-slash'      => 'fa-microphone-slash',
			'fa-shield'                => 'fa-shield',
			'fa-calendar-o'            => 'fa-calendar-o',
			'fa-fire-extinguisher'     => 'fa-fire-extinguisher',
			'fa-rocket'                => 'fa-rocket',
			'fa-maxcdn'                => 'fa-maxcdn',
			'fa-chevron-circle-left'   => 'fa-chevron-circle-left',
			'fa-chevron-circle-right'  => 'fa-chevron-circle-right',
			'fa-chevron-circle-up'     => 'fa-chevron-circle-up',
			'fa-chevron-circle-down'   => 'fa-chevron-circle-down',
			'fa-html5'                 => 'fa-html5',
			'fa-css3'                  => 'fa-css3',
			'fa-anchor'                => 'fa-anchor',
			'fa-unlock-alt'            => 'fa-unlock-alt',
			'fa-bullseye'              => 'fa-bullseye',
			'fa-ellipsis-h'            => 'fa-ellipsis-h',
			'fa-ellipsis-v'            => 'fa-ellipsis-v',
			'fa-rss-square'            => 'fa-rss-square',
			'fa-play-circle'           => 'fa-play-circle',
			'fa-ticket'                => 'fa-ticket',
			'fa-minus-square'          => 'fa-minus-square',
			'fa-minus-square-o'        => 'fa-minus-square-o',
			'fa-level-up'              => 'fa-level-up',
			'fa-level-down'            => 'fa-level-down',
			'fa-check-square'          => 'fa-check-square',
			'fa-pencil-square'         => 'fa-pencil-square',
			'fa-external-link-square'  => 'fa-external-link-square',
			'fa-share-square'          => 'fa-share-square',
			'fa-compass'               => 'fa-compass',
			'fa-toggle-down'           => 'fa-toggle-down',
			'fa-toggle-up'             => 'fa-toggle-up',
			'fa-toggle-right'          => 'fa-toggle-right',
			'fa-euro'                  => 'fa-euro',
			'fa-eur'                   => 'fa-eur',
			'fa-gbp'                   => 'fa-gbp',
			'fa-dollar'                => 'fa-dollar',
			'fa-rupee'                 => 'fa-rupee',
			'fa-inr'                   => 'fa-inr',
			'fa-cny'                   => 'fa-cny',
			'fa-rmb'                   => 'fa-rmb',
			'fa-yen'                   => 'fa-yen',
			'fa-jpy'                   => 'fa-jpy',
			'fa-ruble'                 => 'fa-ruble',
			'fa-rouble'                => 'fa-rouble',
			'fa-rub'                   => 'fa-rub',
			'fa-won'                   => 'fa-won',
			'fa-krw'                   => 'fa-krw',
			'fa-bitcoin'               => 'fa-bitcoin',
			'fa-btc'                   => 'fa-btc',
			'fa-file'                  => 'fa-file',
			'fa-file-text'             => 'fa-file-text',
			'fa-sort-alpha-asc'        => 'fa-sort-alpha-asc',
			'fa-sort-alpha-desc'       => 'fa-sort-alpha-desc',
			'fa-sort-amount-asc'       => 'fa-sort-amount-asc',
			'fa-sort-amount-desc'      => 'fa-sort-amount-desc',
			'fa-sort-numeric-asc'      => 'fa-sort-numeric-asc',
			'fa-sort-numeric-desc'     => 'fa-sort-numeric-desc',
			'fa-thumbs-up'             => 'fa-thumbs-up',
			'fa-thumbs-down'           => 'fa-thumbs-down',
			'fa-youtube-square'        => 'fa-youtube-square',
			'fa-youtube'               => 'fa-youtube',
			'fa-xing'                  => 'fa-xing',
			'fa-xing-square'           => 'fa-xing-square',
			'fa-dropbox'               => 'fa-dropbox',
			'fa-stack-overflow'        => 'fa-stack-overflow',
			'fa-instagram'             => 'fa-instagram',
			'fa-flickr'                => 'fa-flickr',
			'fa-adn'                   => 'fa-adn',
			'fa-bitbucket'             => 'fa-bitbucket',
			'fa-bitbucket-square'      => 'fa-bitbucket-square',
			'fa-tumblr'                => 'fa-tumblr',
			'fa-tumblr-square'         => 'fa-tumblr-square',
			'fa-long-arrow-down'       => 'fa-long-arrow-down',
			'fa-long-arrow-up'         => 'fa-long-arrow-up',
			'fa-long-arrow-left'       => 'fa-long-arrow-left',
			'fa-long-arrow-right'      => 'fa-long-arrow-right',
			'fa-apple'                 => 'fa-apple',
			'fa-windows'               => 'fa-windows',
			'fa-android'               => 'fa-android',
			'fa-linux'                 => 'fa-linux',
			'fa-dribbble'              => 'fa-dribbble',
			'fa-skype'                 => 'fa-skype',
			'fa-foursquare'            => 'fa-foursquare',
			'fa-trello'                => 'fa-trello',
			'fa-female'                => 'fa-female',
			'fa-male'                  => 'fa-male',
			'fa-gittip'                => 'fa-gittip',
			'fa-gratipay'              => 'fa-gratipay',
			'fa-sun-o'                 => 'fa-sun-o',
			'fa-moon-o'                => 'fa-moon-o',
			'fa-archive'               => 'fa-archive',
			'fa-bug'                   => 'fa-bug',
			'fa-vk'                    => 'fa-vk',
			'fa-weibo'                 => 'fa-weibo',
			'fa-renren'                => 'fa-renren',
			'fa-pagelines'             => 'fa-pagelines',
			'fa-stack-exchange'        => 'fa-stack-exchange',
			'fa-arrow-circle-o-right'  => 'fa-arrow-circle-o-right',
			'fa-arrow-circle-o-left'   => 'fa-arrow-circle-o-left',
			'fa-toggle-left'           => 'fa-toggle-left',
			'fa-dot-circle-o'          => 'fa-dot-circle-o',
			'fa-wheelchair'            => 'fa-wheelchair',
			'fa-vimeo-square'          => 'fa-vimeo-square',
			'fa-turkish-lira'          => 'fa-turkish-lira',
			'fa-try'                   => 'fa-try',
			'fa-plus-square-o'         => 'fa-plus-square-o',
			'fa-space-shuttle'         => 'fa-space-shuttle',
			'fa-slack'                 => 'fa-slack',
			'fa-envelope-square'       => 'fa-envelope-square',
			'fa-wordpress'             => 'fa-wordpress',
			'fa-openid'                => 'fa-openid',
			'fa-bank'                  => 'fa-bank',
			'fa-graduation-cap'        => 'fa-graduation-cap',
			'fa-yahoo'                 => 'fa-yahoo',
			'fa-google'                => 'fa-google',
			'fa-reddit'                => 'fa-reddit',
			'fa-reddit-square'         => 'fa-reddit-square',
			'fa-stumbleupon-circle'    => 'fa-stumbleupon-circle',
			'fa-stumbleupon'           => 'fa-stumbleupon',
			'fa-delicious'             => 'fa-delicious',
			'fa-digg'                  => 'fa-digg',
			'fa-pied-piper-pp'         => 'fa-pied-piper-pp',
			'fa-pied-piper-alt'        => 'fa-pied-piper-alt',
			'fa-drupal'                => 'fa-drupal',
			'fa-joomla'                => 'fa-joomla',
			'fa-language'              => 'fa-language',
			'fa-fax'                   => 'fa-fax',
			'fa-building'              => 'fa-building',
			'fa-child'                 => 'fa-child',
			'fa-paw'                   => 'fa-paw',
			'fa-spoon'                 => 'fa-spoon',
			'fa-cube'                  => 'fa-cube',
			'fa-cubes'                 => 'fa-cubes',
			'fa-behance'               => 'fa-behance',
			'fa-behance-square'        => 'fa-behance-square',
			'fa-steam'                 => 'fa-steam',
			'fa-steam-square'          => 'fa-steam-square',
			'fa-recycle'               => 'fa-recycle',
			'fa-car'                   => 'fa-car',
			'fa-cab'                   => 'fa-cab',
			'fa-taxi'                  => 'fa-taxi',
			'fa-tree'                  => 'fa-tree',
			'fa-spotify'               => 'fa-spotify',
			'fa-deviantart'            => 'fa-deviantart',
			'fa-soundcloud'            => 'fa-soundcloud',
			'fa-vine'                  => 'fa-vine',
			'fa-codepen'               => 'fa-codepen',
			'fa-jsfiddle'              => 'fa-jsfiddle',
			'fa-life-saver'            => 'fa-life-saver',
			'fa-circle-o-notch'        => 'fa-circle-o-notch',
			'fa-rebel'                 => 'fa-rebel',
			'fa-ge'                    => 'fa-ge',
			'fa-empire'                => 'fa-empire',
			'fa-git-square'            => 'fa-git-square',
			'fa-git'                   => 'fa-git',
			'fa-yc-square'             => 'fa-yc-square',
			'fa-hacker-news'           => 'fa-hacker-news',
			'fa-tencent-weibo'         => 'fa-tencent-weibo',
			'fa-qq'                    => 'fa-qq',
			'fa-wechat'                => 'fa-wechat',
			'fa-paper-plane'           => 'fa-paper-plane',
			'fa-paper-plane-o'         => 'fa-paper-plane-o',
			'fa-history'               => 'fa-history',
			'fa-circle-thin'           => 'fa-circle-thin',
			'fa-header'                => 'fa-header',
			'fa-paragraph'             => 'fa-paragraph',
			'fa-sliders'               => 'fa-sliders',
			'fa-share-alt'             => 'fa-share-alt',
			'fa-share-alt-square'      => 'fa-share-alt-square',
			'fa-bomb'                  => 'fa-bomb',
			'fa-soccer-ball-o'         => 'fa-soccer-ball-o',
			'fa-futbol-o'              => 'fa-futbol-o',
			'fa-tty'                   => 'fa-tty',
			'fa-binoculars'            => 'fa-binoculars',
			'fa-plug'                  => 'fa-plug',
			'fa-slideshare'            => 'fa-slideshare',
			'fa-twitch'                => 'fa-twitch',
			'fa-yelp'                  => 'fa-yelp',
			'fa-newspaper-o'           => 'fa-newspaper-o',
			'fa-wifi'                  => 'fa-wifi',
			'fa-calculator'            => 'fa-calculator',
			'fa-paypal'                => 'fa-paypal',
			'fa-google-wallet'         => 'fa-google-wallet',
			'fa-cc-visa'               => 'fa-cc-visa',
			'fa-cc-mastercard'         => 'fa-cc-mastercard',
			'fa-cc-discover'           => 'fa-cc-discover',
			'fa-cc-amex'               => 'fa-cc-amex',
			'fa-cc-paypal'             => 'fa-cc-paypal',
			'fa-cc-stripe'             => 'fa-cc-stripe',
			'fa-bell-slash'            => 'fa-bell-slash',
			'fa-bell-slash-o'          => 'fa-bell-slash-o',
			'fa-trash'                 => 'fa-trash',
			'fa-copyright'             => 'fa-copyright',
			'fa-at'                    => 'fa-at',
			'fa-eyedropper'            => 'fa-eyedropper',
			'fa-paint-brush'           => 'fa-paint-brush',
			'fa-birthday-cake'         => 'fa-birthday-cake',
			'fa-area-chart'            => 'fa-area-chart',
			'fa-pie-chart'             => 'fa-pie-chart',
			'fa-line-chart'            => 'fa-line-chart',
			'fa-lastfm'                => 'fa-lastfm',
			'fa-lastfm-square'         => 'fa-lastfm-square',
			'fa-toggle-off'            => 'fa-toggle-off',
			'fa-toggle-on'             => 'fa-toggle-on',
			'fa-bicycle'               => 'fa-bicycle',
			'fa-bus'                   => 'fa-bus',
			'fa-ioxhost'               => 'fa-ioxhost',
			'fa-angellist'             => 'fa-angellist',
			'fa-cc'                    => 'fa-cc',
			'fa-shekel'                => 'fa-shekel',
			'fa-sheqel'                => 'fa-sheqel',
			'fa-ils'                   => 'fa-ils',
			'fa-meanpath'              => 'fa-meanpath',
			'fa-buysellads'            => 'fa-buysellads',
			'fa-connectdevelop'        => 'fa-connectdevelop',
			'fa-dashcube'              => 'fa-dashcube',
			'fa-forumbee'              => 'fa-forumbee',
			'fa-leanpub'               => 'fa-leanpub',
			'fa-sellsy'                => 'fa-sellsy',
			'fa-shirtsinbulk'          => 'fa-shirtsinbulk',
			'fa-simplybuilt'           => 'fa-simplybuilt',
			'fa-skyatlas'              => 'fa-skyatlas',
			'fa-cart-plus'             => 'fa-cart-plus',
			'fa-cart-arrow-down'       => 'fa-cart-arrow-down',
			'fa-diamond'               => 'fa-diamond',
			'fa-ship'                  => 'fa-ship',
			'fa-user-secret'           => 'fa-user-secret',
			'fa-motorcycle'            => 'fa-motorcycle',
			'fa-street-view'           => 'fa-street-view',
			'fa-heartbeat'             => 'fa-heartbeat',
			'fa-venus'                 => 'fa-venus',
			'fa-mars'                  => 'fa-mars',
			'fa-mercury'               => 'fa-mercury',
			'fa-intersex'              => 'fa-intersex',
			'fa-transgender-alt'       => 'fa-transgender-alt',
			'fa-venus-double'          => 'fa-venus-double',
			'fa-mars-double'           => 'fa-mars-double',
			'fa-venus-mars'            => 'fa-venus-mars',
			'fa-mars-stroke'           => 'fa-mars-stroke',
			'fa-mars-stroke-v'         => 'fa-mars-stroke-v',
			'fa-mars-stroke-h'         => 'fa-mars-stroke-h',
			'fa-neuter'                => 'fa-neuter',
			'fa-genderless'            => 'fa-genderless',
			'fa-facebook-official'     => 'fa-facebook-official',
			'fa-pinterest-p'           => 'fa-pinterest-p',
			'fa-whatsapp'              => 'fa-whatsapp',
			'fa-server'                => 'fa-server',
			'fa-user-plus'             => 'fa-user-plus',
			'fa-user-times'            => 'fa-user-times',
			'fa-hotel'                 => 'fa-hotel',
			'fa-bed'                   => 'fa-bed',
			'fa-viacoin'               => 'fa-viacoin',
			'fa-train'                 => 'fa-train',
			'fa-subway'                => 'fa-subway',
			'fa-medium'                => 'fa-medium',
			'fa-yc'                    => 'fa-yc',
			'fa-optin-monster'         => 'fa-optin-monster',
			'fa-opencart'              => 'fa-opencart',
			'fa-expeditedssl'          => 'fa-expeditedssl',
			'fa-battery-full'          => 'fa-battery-full',
			'fa-battery-three-quarters' => 'fa-battery-three-quarters',
			'fa-battery-half'          => 'fa-battery-half',
			'fa-battery-quarter'       => 'fa-battery-quarter',
			'fa-battery-empty'         => 'fa-battery-empty',
			'fa-mouse-pointer'         => 'fa-mouse-pointer',
			'fa-i-cursor'              => 'fa-i-cursor',
			'fa-object-group'          => 'fa-object-group',
			'fa-object-ungroup'        => 'fa-object-ungroup',
			'fa-sticky-note'           => 'fa-sticky-note',
			'fa-sticky-note-o'         => 'fa-sticky-note-o',
			'fa-cc-jcb'                => 'fa-cc-jcb',
			'fa-cc-diners-club'        => 'fa-cc-diners-club',
			'fa-clone'                 => 'fa-clone',
			'fa-balance-scale'         => 'fa-balance-scale',
			'fa-hourglass-o'           => 'fa-hourglass-o',
			'fa-hourglass-start'       => 'fa-hourglass-start',
			'fa-hourglass-half'        => 'fa-hourglass-half',
			'fa-hourglass-end'         => 'fa-hourglass-end',
			'fa-hourglass'             => 'fa-hourglass',
			'fa-hand-rock-o'           => 'fa-hand-rock-o',
			'fa-hand-paper-o'          => 'fa-hand-paper-o',
			'fa-hand-scissors-o'       => 'fa-hand-scissors-o',
			'fa-hand-lizard-o'         => 'fa-hand-lizard-o',
			'fa-hand-spock-o'          => 'fa-hand-spock-o',
			'fa-hand-pointer-o'        => 'fa-hand-pointer-o',
			'fa-hand-peace-o'          => 'fa-hand-peace-o',
			'fa-trademark'             => 'fa-trademark',
			'fa-registered'            => 'fa-registered',
			'fa-creative-commons'      => 'fa-creative-commons',
			'fa-gg'                    => 'fa-gg',
			'fa-gg-circle'             => 'fa-gg-circle',
			'fa-tripadvisor'           => 'fa-tripadvisor',
			'fa-odnoklassniki'         => 'fa-odnoklassniki',
			'fa-odnoklassniki-square'  => 'fa-odnoklassniki-square',
			'fa-get-pocket'            => 'fa-get-pocket',
			'fa-wikipedia-w'           => 'fa-wikipedia-w',
			'fa-safari'                => 'fa-safari',
			'fa-chrome'                => 'fa-chrome',
			'fa-firefox'               => 'fa-firefox',
			'fa-opera'                 => 'fa-opera',
			'fa-internet-explorer'     => 'fa-internet-explorer',
			'fa-tv'                    => 'fa-tv',
			'fa-contao'                => 'fa-contao',
			'fa-500px'                 => 'fa-500px',
			'fa-amazon'                => 'fa-amazon',
			'fa-calendar-plus-o'       => 'fa-calendar-plus-o',
			'fa-calendar-minus-o'      => 'fa-calendar-minus-o',
			'fa-calendar-times-o'      => 'fa-calendar-times-o',
			'fa-calendar-check-o'      => 'fa-calendar-check-o',
			'fa-industry'              => 'fa-industry',
			'fa-map-pin'               => 'fa-map-pin',
			'fa-map-signs'             => 'fa-map-signs',
			'fa-map-o'                 => 'fa-map-o',
			'fa-map'                   => 'fa-map',
			'fa-commenting'            => 'fa-commenting',
			'fa-commenting-o'          => 'fa-commenting-o',
			'fa-houzz'                 => 'fa-houzz',
			'fa-vimeo'                 => 'fa-vimeo',
			'fa-black-tie'             => 'fa-black-tie',
			'fa-fonticons'             => 'fa-fonticons',
			'fa-reddit-alien'          => 'fa-reddit-alien',
			'fa-edge'                  => 'fa-edge',
			'fa-credit-card-alt'       => 'fa-credit-card-alt',
			'fa-codiepie'              => 'fa-codiepie',
			'fa-modx'                  => 'fa-modx',
			'fa-fort-awesome'          => 'fa-fort-awesome',
			'fa-usb'                   => 'fa-usb',
			'fa-product-hunt'          => 'fa-product-hunt',
			'fa-mixcloud'              => 'fa-mixcloud',
			'fa-scribd'                => 'fa-scribd',
			'fa-pause-circle'          => 'fa-pause-circle',
			'fa-pause-circle-o'        => 'fa-pause-circle-o',
			'fa-stop-circle'           => 'fa-stop-circle',
			'fa-stop-circle-o'         => 'fa-stop-circle-o',
			'fa-shopping-bag'          => 'fa-shopping-bag',
			'fa-shopping-basket'       => 'fa-shopping-basket',
			'fa-hashtag'               => 'fa-hashtag',
			'fa-bluetooth'             => 'fa-bluetooth',
			'fa-bluetooth-b'           => 'fa-bluetooth-b',
			'fa-percent'               => 'fa-percent',
			'fa-gitlab'                => 'fa-gitlab',
			'fa-wpbeginner'            => 'fa-wpbeginner',
			'fa-wpforms'               => 'fa-wpforms',
			'fa-envira'                => 'fa-envira',
			'fa-universal-access'      => 'fa-universal-access',
			'fa-wheelchair-alt'        => 'fa-wheelchair-alt',
			'fa-question-circle-o'     => 'fa-question-circle-o',
			'fa-blind'                 => 'fa-blind',
			'fa-audio-description'     => 'fa-audio-description',
			'fa-volume-control-phone'  => 'fa-volume-control-phone',
			'fa-braille'               => 'fa-braille',
			'fa-assistive-listening-systems' => 'fa-assistive-listening-systems',
			'fa-american-sign-language-interpreting' => 'fa-american-sign-language-interpreting',
			'fa-hard-of-hearing'       => 'fa-hard-of-hearing',
			'fa-glide'                 => 'fa-glide',
			'fa-glide-g'               => 'fa-glide-g',
			'fa-sign-language'         => 'fa-sign-language',
			'fa-low-vision'            => 'fa-low-vision',
			'fa-viadeo'                => 'fa-viadeo',
			'fa-viadeo-square'         => 'fa-viadeo-square',
			'fa-snapchat'              => 'fa-snapchat',
			'fa-snapchat-ghost'        => 'fa-snapchat-ghost',
			'fa-snapchat-square'       => 'fa-snapchat-square',
			'fa-pied-piper'            => 'fa-pied-piper',
			'fa-first-order'           => 'fa-first-order',
			'fa-yoast'                 => 'fa-yoast',
			'fa-themeisle'             => 'fa-themeisle',
			'fa-google-plus-circle'    => 'fa-google-plus-circle',
			'fa-google-plus-official'  => 'fa-google-plus-official',
			'fa-font-awesome'          => 'fa-font-awesome',
			'fa-handshake-o'           => 'fa-handshake-o',
			'fa-envelope-open'         => 'fa-envelope-open',
			'fa-envelope-open-o'       => 'fa-envelope-open-o',
			'fa-linode'                => 'fa-linode',
			'fa-address-book'          => 'fa-address-book',
			'fa-address-book-o'        => 'fa-address-book-o',
			'fa-address-card'          => 'fa-address-card',
			'fa-address-card-o'        => 'fa-address-card-o',
			'fa-user-circle'           => 'fa-user-circle',
			'fa-user-circle-o'         => 'fa-user-circle-o',
			'fa-user-o'                => 'fa-user-o',
			'fa-id-badge'              => 'fa-id-badge',
			'fa-id-card'               => 'fa-id-card',
			'fa-id-card-o'             => 'fa-id-card-o',
			'fa-quora'                 => 'fa-quora',
			'fa-free-code-camp'        => 'fa-free-code-camp',
			'fa-telegram'              => 'fa-telegram',
			'fa-thermometer-full'      => 'fa-thermometer-full',
			'fa-thermometer-three-quarters' => 'fa-thermometer-three-quarters',
			'fa-thermometer-half'      => 'fa-thermometer-half',
			'fa-thermometer-quarter'   => 'fa-thermometer-quarter',
			'fa-thermometer-0'         => 'fa-thermometer-0'       ,
			'fa-thermometer-empty'     => 'fa-thermometer-empty',
			'fa-shower'                => 'fa-shower',
			'fa-bathtub'               => 'fa-bathtub'       ,
			'fa-s15'                   => 'fa-s15'       ,
			'fa-podcast'               => 'fa-podcast',
			'fa-window-maximize'       => 'fa-window-maximize',
			'fa-window-minimize'       => 'fa-window-minimize',
			'fa-window-restore'        => 'fa-window-restore',
			'fa-window-close'          => 'fa-window-close',
			'fa-window-close-o'        => 'fa-window-close-o',
			'fa-bandcamp'              => 'fa-bandcamp',
			'fa-grav'                  => 'fa-grav',
			'fa-etsy'                  => 'fa-etsy',
			'fa-imdb'                  => 'fa-imdb',
			'fa-ravelry'               => 'fa-ravelry',
			'fa-eercast'               => 'fa-eercast',
			'fa-microchip'             => 'fa-microchip',
			'fa-snowflake-o'           => 'fa-snowflake-o',
			'fa-superpowers'           => 'fa-superpowers',
			'fa-wpexplorer'            => 'fa-wpexplorer',
			'fa-meetup'                => 'fa-meetup'
		);
		ksort($all_icons);

		return $all_icons;
	}

	public static function get_epkbfa_all_icons(){
		$all_icons = array(

			//Echo Custom Icons ( Value => Name )
			'ep_font_icon_none'                         => '-- No Icon --',
			'ep_font_icon_book'                         => 'Book',
			'ep_font_icon_brief_case'                   => 'Brief Case',
			'ep_font_icon_building'                     => 'Building',
			'ep_font_icon_clip_board'                   => 'Clip Board',
			'ep_font_icon_comment'                      => 'Comments',
			'ep_font_icon_credit_card'                  => 'Credit Card',
			'ep_font_icon_data_report'                  => 'Data Report',
			'ep_font_icon_document'                     => 'Document',
			'ep_font_icon_documents'                    => 'Documents',
			'ep_font_icon_external_link'                => 'External Link',
			'ep_font_icon_flow_chart'                   => 'Flow Chart',
			'ep_font_icon_folder'                       => 'Folder',
			'ep_font_icon_folder_add'                   => 'Folder Add',
			'ep_font_icon_folder_open'                  => 'Open Folder',
			'ep_font_icon_gear'                         => 'Gear',
			'ep_font_icon_gears'                        => 'Gears',
			'ep_font_icon_hour_glass'                   => 'Hour Glass',
			'ep_font_icon_house'                        => 'House',
			'ep_font_icon_info'                         => 'Info',
			'ep_font_icon_life_saver'                   => 'Life Saver',
			'ep_font_icon_light_bulb'                   => 'Light Bulb',
			'ep_font_icon_map'                          => 'Map',
			'ep_font_icon_money'                        => 'Money',
			'ep_font_icon_paperclip'                    => 'Paper Clip',
			'ep_font_icon_pencil'                       => 'Pencil',
			'ep_font_icon_people'                       => 'People',
			'ep_font_icon_person'                       => 'Person',
			'ep_font_icon_plus'                         => 'Plus',
			'ep_font_icon_question'                     => 'Question',
			'ep_font_icon_screen'                       => 'Screen',
			'ep_font_icon_screw_driver'                  => 'Screw Driver',
			'ep_font_icon_shopping_cart'                => 'Shopping Cart',
			'ep_font_icon_tag'                          => 'Tag',
			'ep_font_icon_tools'                        => 'Tools',
			'ep_font_icon_wrench'                       => 'Wrench',
			'ep_font_icon_empty_star'                   => 'Empty Star',
			'ep_font_icon_full_star'                    => 'Full Star',
			'ep_font_icon_half_star'                    => 'Half Star',
			'ep_font_icon_plus_box'                     => 'Plus Box',
			'ep_font_icon_minus'                        => 'Minus',
			'ep_font_icon_minus_box'                    => 'Minus Box',
			'ep_font_icon_up_arrow'                     => 'Up Arrow',
			'ep_font_icon_down_arrow'                   => 'Down Arrow',
			'ep_font_icon_right_arrow'                  => 'Right Arrow',
			'ep_font_icon_left_arrow'                   => 'Left Arrow',
			'ep_font_icon_error_circle'                 => 'Error Circle',
			'ep_font_icon_error_oct'                    => 'Error Octagon',
			'ep_font_icon_error_triangle'               => 'Error Triangle',
			'ep_font_icon_arrow_carrot_up_circle'       => 'Arrow Up Circle',
			'ep_font_icon_arrow_carrot_right_circle'    => 'Arrow Right Circle',
			'ep_font_icon_arrow_carrot_down_circle'     => 'Arrow Down Circle',
			'ep_font_icon_arrow_carrot_left_circle'     => 'Arrow Left Circle',
			'ep_font_icon_arrow_carrot_left'            => 'Arrow Caret Left',
			'ep_font_icon_arrow_carrot_right'           => 'Arrow Caret Right',
			'ep_font_icon_arrow_carrot_up'              => 'Arrow Caret Up',
			'ep_font_icon_arrow_carrot_down'            => 'Arrow Caret Down',

			//Font Awesome Icons	( Value => Name )
			'epkbfa-file-pdf-o'            => 'epkbfa-file-pdf-o',
			'epkbfa-file-text-o'           => 'epkbfa-file-text-o',
			'epkbfa-file-word-o'           => 'epkbfa-file-word-o',
			'epkbfa-file-excel-o'          => 'epkbfa-file-excel-o',
			'epkbfa-file-image-o'          => 'epkbfa-file-image-o',
			'epkbfa-file-zip-o'            => 'epkbfa-file-zip-o',
			'epkbfa-file-audio-o'          => 'epkbfa-file-audio-o',
			'epkbfa-file-video-o'          => 'epkbfa-file-video-o',
			'epkbfa-link'                  => 'epkbfa-link',
			'epkbfa-youtube-play'          => 'epkbfa-youtube-play',
			'epkbfa-download'              => 'epkbfa-download',
			'epkbfa-external-link'         => 'epkbfa-external-link',
			'epkbfa-file-code-o'           => 'epkbfa-file-code-o',
			'epkbfa-file-o'                => 'epkbfa-file-o',
			'epkbfa-files-o'               => 'epkbfa-files-o',
			'epkbfa-folder-open'           => 'epkbfa-folder-open',
			'epkbfa-code'                  => 'epkbfa-code',
			'epkbfa-clipboard'             => 'epkbfa-clipboard',
			'epkbfa-book'                  => 'epkbfa-book',
			'epkbfa-info-circle'           => 'epkbfa-info-circle',
			'epkbfa-question-circle'       => 'epkbfa-question-circle',
			'epkbfa-exclamation-circle'    => 'epkbfa-exclamation-circle',
			'epkbfa-database'              => 'epkbfa-database',
			'epkbfa-file-powerpoint-o'     => 'epkbfa-file-powerpoint-o',
			'epkbfa-image'                 => 'epkbfa-image',
			'epkbfa-lock'                  => 'epkbfa-lock',
			'epkbfa-print'                 => 'epkbfa-print',
			'epkbfa-user'                  => 'epkbfa-user',
			'epkbfa-glass'                 => 'epkbfa-glass',
			'epkbfa-music'                 => 'epkbfa-music',
			'epkbfa-search'                => 'epkbfa-search',
			'epkbfa-envelope-o'            => 'epkbfa-envelope-o',
			'epkbfa-heart'                 => 'epkbfa-heart',
			'epkbfa-star'                  => 'epkbfa-star',
			'epkbfa-star-o'                => 'epkbfa-star-o',
			'epkbfa-film'                  => 'epkbfa-film',
			'epkbfa-th-large'              => 'epkbfa-th-large',
			'epkbfa-th'                    => 'epkbfa-th',
			'epkbfa-th-list'               => 'epkbfa-th-list',
			'epkbfa-check'                 => 'epkbfa-check',
			'epkbfa-close'                 => 'epkbfa-close',
			'epkbfa-search-plus'           => 'epkbfa-search-plus',
			'epkbfa-search-minus'          => 'epkbfa-search-minus',
			'epkbfa-power-off'             => 'epkbfa-power-off',
			'epkbfa-signal'                => 'epkbfa-signal',
			'epkbfa-gear'                  => 'epkbfa-gear',
			'epkbfa-trash-o'               => 'epkbfa-trash-o',
			'epkbfa-home'                  => 'epkbfa-home',
			'epkbfa-clock-o'               => 'epkbfa-clock-o',
			'epkbfa-road'                  => 'epkbfa-road',
			'epkbfa-arrow-circle-o-down'   => 'epkbfa-arrow-circle-o-down',
			'epkbfa-arrow-circle-o-up'     => 'epkbfa-arrow-circle-o-up',
			'epkbfa-inbox'                 => 'epkbfa-inbox',
			'epkbfa-play-circle-o'         => 'epkbfa-play-circle-o',
			'epkbfa-rotate-right'          => 'epkbfa-rotate-right',
			'epkbfa-repeat'                => 'epkbfa-repeat',
			'epkbfa-refresh'               => 'epkbfa-refresh',
			'epkbfa-list-alt'              => 'epkbfa-list-alt',
			'epkbfa-flag'                  => 'epkbfa-flag',
			'epkbfa-headphones'            => 'epkbfa-headphones',
			'epkbfa-volume-off'            => 'epkbfa-volume-off',
			'epkbfa-volume-down'           => 'epkbfa-volume-down',
			'epkbfa-volume-up'             => 'epkbfa-volume-up',
			'epkbfa-qrcode'                => 'epkbfa-qrcode',
			'epkbfa-barcode'               => 'epkbfa-barcode',
			'epkbfa-tag'                   => 'epkbfa-tag',
			'epkbfa-tags'                  => 'epkbfa-tags',
			'epkbfa-bookmark'              => 'epkbfa-bookmark',
			'epkbfa-camera'                => 'epkbfa-camera',
			'epkbfa-font'                  => 'epkbfa-font',
			'epkbfa-bold'                  => 'epkbfa-bold',
			'epkbfa-italic'                => 'epkbfa-italic',
			'epkbfa-text-height'           => 'epkbfa-text-height',
			'epkbfa-text-width'            => 'epkbfa-text-width',
			'epkbfa-align-left'            => 'epkbfa-align-left',
			'epkbfa-align-center'          => 'epkbfa-align-center',
			'epkbfa-align-right'           => 'epkbfa-align-right',
			'epkbfa-align-justify'         => 'epkbfa-align-justify',
			'epkbfa-list'                  => 'epkbfa-list',
			'epkbfa-dedent'                => 'epkbfa-dedent',
			'epkbfa-outdent'               => 'epkbfa-outdent',
			'epkbfa-indent'                => 'epkbfa-indent',
			'epkbfa-video-camera'          => 'epkbfa-video-camera',
			'epkbfa-photo'                 => 'epkbfa-photo',
			'epkbfa-pencil'                => 'epkbfa-pencil',
			'epkbfa-map-marker'            => 'epkbfa-map-marker',
			'epkbfa-adjust'                => 'epkbfa-adjust',
			'epkbfa-tint'                  => 'epkbfa-tint',
			'epkbfa-edit'                  => 'epkbfa-edit',
			'epkbfa-pencil-square-o'       => 'epkbfa-pencil-square-o',
			'epkbfa-share-square-o'        => 'epkbfa-share-square-o',
			'epkbfa-check-square-o'        => 'epkbfa-check-square-o',
			'epkbfa-arrows'                => 'epkbfa-arrows',
			'epkbfa-step-backward'         => 'epkbfa-step-backward',
			'epkbfa-fast-backward'         => 'epkbfa-fast-backward',
			'epkbfa-backward'              => 'epkbfa-backward',
			'epkbfa-play'                  => 'epkbfa-play',
			'epkbfa-pause'                 => 'epkbfa-pause',
			'epkbfa-stop'                  => 'epkbfa-stop',
			'epkbfa-forward'               => 'epkbfa-forward',
			'epkbfa-fast-forward'          => 'epkbfa-fast-forward',
			'epkbfa-step-forward'          => 'epkbfa-step-forward',
			'epkbfa-eject'                 => 'epkbfa-eject',
			'epkbfa-chevron-left'          => 'epkbfa-chevron-left',
			'epkbfa-chevron-right'         => 'epkbfa-chevron-right',
			'epkbfa-plus-circle'           => 'epkbfa-plus-circle',
			'epkbfa-minus-circle'          => 'epkbfa-minus-circle',
			'epkbfa-times-circle'          => 'epkbfa-times-circle',
			'epkbfa-check-circle'          => 'epkbfa-check-circle',
			'epkbfa-crosshairs'            => 'epkbfa-crosshairs',
			'epkbfa-times-circle-o'        => 'epkbfa-times-circle-o',
			'epkbfa-check-circle-o'        => 'epkbfa-check-circle-o',
			'epkbfa-ban'                   => 'epkbfa-ban',
			'epkbfa-arrow-left'            => 'epkbfa-arrow-left',
			'epkbfa-arrow-right'           => 'epkbfa-arrow-right',
			'epkbfa-arrow-up'              => 'epkbfa-arrow-up',
			'epkbfa-arrow-down'            => 'epkbfa-arrow-down',
			'epkbfa-share'                 => 'epkbfa-share',
			'epkbfa-expand'                => 'epkbfa-expand',
			'epkbfa-compress'              => 'epkbfa-compress',
			'epkbfa-plus'                  => 'epkbfa-plus',
			'epkbfa-minus'                 => 'epkbfa-minus',
			'epkbfa-asterisk'              => 'epkbfa-asterisk',
			'epkbfa-gift'                  => 'epkbfa-gift',
			'epkbfa-leaf'                  => 'epkbfa-leaf',
			'epkbfa-fire'                  => 'epkbfa-fire',
			'epkbfa-eye'                   => 'epkbfa-eye',
			'epkbfa-eye-slash'             => 'epkbfa-eye-slash',
			'epkbfa-warning'               => 'epkbfa-warning',
			'epkbfa-plane'                 => 'epkbfa-plane',
			'epkbfa-calendar'              => 'epkbfa-calendar',
			'epkbfa-random'                => 'epkbfa-random',
			'epkbfa-comment'               => 'epkbfa-comment',
			'epkbfa-magnet'                => 'epkbfa-magnet',
			'epkbfa-chevron-up'            => 'epkbfa-chevron-up',
			'epkbfa-chevron-down'          => 'epkbfa-chevron-down',
			'epkbfa-retweet'               => 'epkbfa-retweet',
			'epkbfa-shopping-cart'         => 'epkbfa-shopping-cart',
			'epkbfa-folder'                => 'epkbfa-folder',
			'epkbfa-arrows-v'              => 'epkbfa-arrows-v',
			'epkbfa-arrows-h'              => 'epkbfa-arrows-h',
			'epkbfa-bar-chart'             => 'epkbfa-bar-chart',
			'epkbfa-twitter-square'        => 'epkbfa-twitter-square',
			'epkbfa-facebook-square'       => 'epkbfa-facebook-square',
			'epkbfa-camera-retro'          => 'epkbfa-camera-retro',
			'epkbfa-key'                   => 'epkbfa-key',
			'epkbfa-gears'                 => 'epkbfa-gears',
			'epkbfa-comments'              => 'epkbfa-comments',
			'epkbfa-thumbs-o-up'           => 'epkbfa-thumbs-o-up',
			'epkbfa-thumbs-o-down'         => 'epkbfa-thumbs-o-down',
			'epkbfa-star-half'             => 'epkbfa-star-half',
			'epkbfa-heart-o'               => 'epkbfa-heart-o',
			'epkbfa-sign-out'              => 'epkbfa-sign-out',
			'epkbfa-linkedin-square'       => 'epkbfa-linkedin-square',
			'epkbfa-thumb-tack'            => 'epkbfa-thumb-tack',
			'epkbfa-sign-in'               => 'epkbfa-sign-in',
			'epkbfa-trophy'                => 'epkbfa-trophy',
			'epkbfa-github-square'         => 'epkbfa-github-square',
			'epkbfa-upload'                => 'epkbfa-upload',
			'epkbfa-lemon-o'               => 'epkbfa-lemon-o',
			'epkbfa-phone'                 => 'epkbfa-phone',
			'epkbfa-square-o'              => 'epkbfa-square-o',
			'epkbfa-bookmark-o'            => 'epkbfa-bookmark-o',
			'epkbfa-phone-square'          => 'epkbfa-phone-square',
			'epkbfa-twitter'               => 'epkbfa-twitter',
			'epkbfa-facebook'              => 'epkbfa-facebook',
			'epkbfa-github'                => 'epkbfa-github',
			'epkbfa-unlock'                => 'epkbfa-unlock',
			'epkbfa-credit-card'           => 'epkbfa-credit-card',
			'epkbfa-rss'                   => 'epkbfa-rss',
			'epkbfa-hdd-o'                 => 'epkbfa-hdd-o',
			'epkbfa-bullhorn'              => 'epkbfa-bullhorn',
			'epkbfa-bell'                  => 'epkbfa-bell',
			'epkbfa-certificate'           => 'epkbfa-certificate',
			'epkbfa-hand-o-right'          => 'epkbfa-hand-o-right',
			'epkbfa-hand-o-left'           => 'epkbfa-hand-o-left',
			'epkbfa-hand-o-up'             => 'epkbfa-hand-o-up',
			'epkbfa-hand-o-down'           => 'epkbfa-hand-o-down',
			'epkbfa-arrow-circle-left'     => 'epkbfa-arrow-circle-left',
			'epkbfa-arrow-circle-right'    => 'epkbfa-arrow-circle-right',
			'epkbfa-arrow-circle-up'       => 'epkbfa-arrow-circle-up',
			'epkbfa-arrow-circle-down'     => 'epkbfa-arrow-circle-down',
			'epkbfa-globe'                 => 'epkbfa-globe',
			'epkbfa-wrench'                => 'epkbfa-wrench',
			'epkbfa-tasks'                 => 'epkbfa-tasks',
			'epkbfa-filter'                => 'epkbfa-filter',
			'epkbfa-briefcase'             => 'epkbfa-briefcase',
			'epkbfa-arrows-alt'            => 'epkbfa-arrows-alt',
			'epkbfa-group'                 => 'epkbfa-group',
			'epkbfa-cloud'                 => 'epkbfa-cloud',
			'epkbfa-flask'                 => 'epkbfa-flask',
			'epkbfa-scissors'              => 'epkbfa-scissors',
			'epkbfa-paperclip'             => 'epkbfa-paperclip',
			'epkbfa-save'                  => 'epkbfa-save',
			'epkbfa-floppy-o'              => 'epkbfa-floppy-o',
			'epkbfa-square'                => 'epkbfa-square',
			'epkbfa-navicon'               => 'epkbfa-navicon',
			'epkbfa-bars'                  => 'epkbfa-bars',
			'epkbfa-list-ul'               => 'epkbfa-list-ul',
			'epkbfa-list-ol'               => 'epkbfa-list-ol',
			'epkbfa-strikethrough'         => 'epkbfa-strikethrough',
			'epkbfa-underline'             => 'epkbfa-underline',
			'epkbfa-table'                 => 'epkbfa-table',
			'epkbfa-magic'                 => 'epkbfa-magic',
			'epkbfa-truck'                 => 'epkbfa-truck',
			'epkbfa-pinterest'             => 'epkbfa-pinterest',
			'epkbfa-pinterest-square'      => 'epkbfa-pinterest-square',
			'epkbfa-google-plus-square'    => 'epkbfa-google-plus-square',
			'epkbfa-google-plus'           => 'epkbfa-google-plus',
			'epkbfa-money'                 => 'epkbfa-money',
			'epkbfa-caret-left'            => 'epkbfa-caret-left',
			'epkbfa-caret-right'           => 'epkbfa-caret-right',
			'epkbfa-columns'               => 'epkbfa-columns',
			'epkbfa-unsorted'              => 'epkbfa-unsorted',
			'epkbfa-sort'                  => 'epkbfa-sort',
			'epkbfa-sort-desc'             => 'epkbfa-sort-desc',
			'epkbfa-sort-asc'              => 'epkbfa-sort-asc',
			'epkbfa-envelope'              => 'epkbfa-envelope',
			'epkbfa-linkedin'              => 'epkbfa-linkedin',
			'epkbfa-rotate-left'           => 'epkbfa-rotate-left',
			'epkbfa-legal'                 => 'epkbfa-legal',
			'epkbfa-tachometer'            => 'epkbfa-tachometer',
			'epkbfa-comment-o'             => 'epkbfa-comment-o',
			'epkbfa-comments-o'            => 'epkbfa-comments-o',
			'epkbfa-bolt'                  => 'epkbfa-bolt',
			'epkbfa-sitemap'               => 'epkbfa-sitemap',
			'epkbfa-umbrella'              => 'epkbfa-umbrella',
			'epkbfa-lightbulb-o'           => 'epkbfa-lightbulb-o',
			'epkbfa-exchange'              => 'epkbfa-exchange',
			'epkbfa-cloud-download'        => 'epkbfa-cloud-download',
			'epkbfa-cloud-upload'          => 'epkbfa-cloud-upload',
			'epkbfa-user-md'               => 'epkbfa-user-md',
			'epkbfa-stethoscope'           => 'epkbfa-stethoscope',
			'epkbfa-suitcase'              => 'epkbfa-suitcase',
			'epkbfa-bell-o'                => 'epkbfa-bell-o',
			'epkbfa-coffee'                => 'epkbfa-coffee',
			'epkbfa-cutlery'               => 'epkbfa-cutlery',
			'epkbfa-building-o'            => 'epkbfa-building-o',
			'epkbfa-hospital-o'            => 'epkbfa-hospital-o',
			'epkbfa-ambulance'             => 'epkbfa-ambulance',
			'epkbfa-medkit'                => 'epkbfa-medkit',
			'epkbfa-fighter-jet'           => 'epkbfa-fighter-jet',
			'epkbfa-beer'                  => 'epkbfa-beer',
			'epkbfa-h-square'              => 'epkbfa-h-square',
			'epkbfa-plus-square'           => 'epkbfa-plus-square',
			'epkbfa-angle-double-left'     => 'epkbfa-angle-double-left',
			'epkbfa-angle-double-right'    => 'epkbfa-angle-double-right',
			'epkbfa-angle-double-up'       => 'epkbfa-angle-double-up',
			'epkbfa-angle-double-down'     => 'epkbfa-angle-double-down',
			'epkbfa-angle-left'            => 'epkbfa-angle-left',
			'epkbfa-angle-right'           => 'epkbfa-angle-right',
			'epkbfa-angle-up'              => 'epkbfa-angle-up',
			'epkbfa-angle-down'            => 'epkbfa-angle-down',
			'epkbfa-desktop'               => 'epkbfa-desktop',
			'epkbfa-laptop'                => 'epkbfa-laptop',
			'epkbfa-tablet'                => 'epkbfa-tablet',
			'epkbfa-mobile'                => 'epkbfa-mobile',
			'epkbfa-circle-o'              => 'epkbfa-circle-o',
			'epkbfa-quote-left'            => 'epkbfa-quote-left',
			'epkbfa-quote-right'           => 'epkbfa-quote-right',
			'epkbfa-spinner'               => 'epkbfa-spinner',
			'epkbfa-circle'                => 'epkbfa-circle',
			'epkbfa-reply'                 => 'epkbfa-reply',
			'epkbfa-github-alt'            => 'epkbfa-github-alt',
			'epkbfa-folder-o'              => 'epkbfa-folder-o',
			'epkbfa-folder-open-o'         => 'epkbfa-folder-open-o',
			'epkbfa-smile-o'               => 'epkbfa-smile-o',
			'epkbfa-frown-o'               => 'epkbfa-frown-o',
			'epkbfa-meh-o'                 => 'epkbfa-meh-o',
			'epkbfa-gamepad'               => 'epkbfa-gamepad',
			'epkbfa-keyboard-o'            => 'epkbfa-keyboard-o',
			'epkbfa-flag-o'                => 'epkbfa-flag-o',
			'epkbfa-flag-checkered'        => 'epkbfa-flag-checkered',
			'epkbfa-terminal'              => 'epkbfa-terminal',
			'epkbfa-mail-reply-all'        => 'epkbfa-mail-reply-all',
			'epkbfa-reply-all'             => 'epkbfa-reply-all',
			'epkbfa-star-half-empty'       => 'epkbfa-star-half-empty',
			'epkbfa-location-arrow'        => 'epkbfa-location-arrow',
			'epkbfa-crop'                  => 'epkbfa-crop',
			'epkbfa-code-fork'             => 'epkbfa-code-fork',
			'epkbfa-unlink'                => 'epkbfa-unlink',
			'epkbfa-question'              => 'epkbfa-question',
			'epkbfa-info'                  => 'epkbfa-info',
			'epkbfa-exclamation'           => 'epkbfa-exclamation',
			'epkbfa-superscript'           => 'epkbfa-superscript',
			'epkbfa-subscript'             => 'epkbfa-subscript',
			'epkbfa-eraser'                => 'epkbfa-eraser',
			'epkbfa-puzzle-piece'          => 'epkbfa-puzzle-piece',
			'epkbfa-microphone'            => 'epkbfa-microphone',
			'epkbfa-microphone-slash'      => 'epkbfa-microphone-slash',
			'epkbfa-shield'                => 'epkbfa-shield',
			'epkbfa-calendar-o'            => 'epkbfa-calendar-o',
			'epkbfa-fire-extinguisher'     => 'epkbfa-fire-extinguisher',
			'epkbfa-rocket'                => 'epkbfa-rocket',
			'epkbfa-maxcdn'                => 'epkbfa-maxcdn',
			'epkbfa-chevron-circle-left'   => 'epkbfa-chevron-circle-left',
			'epkbfa-chevron-circle-right'  => 'epkbfa-chevron-circle-right',
			'epkbfa-chevron-circle-up'     => 'epkbfa-chevron-circle-up',
			'epkbfa-chevron-circle-down'   => 'epkbfa-chevron-circle-down',
			'epkbfa-html5'                 => 'epkbfa-html5',
			'epkbfa-css3'                  => 'epkbfa-css3',
			'epkbfa-anchor'                => 'epkbfa-anchor',
			'epkbfa-unlock-alt'            => 'epkbfa-unlock-alt',
			'epkbfa-bullseye'              => 'epkbfa-bullseye',
			'epkbfa-ellipsis-h'            => 'epkbfa-ellipsis-h',
			'epkbfa-ellipsis-v'            => 'epkbfa-ellipsis-v',
			'epkbfa-rss-square'            => 'epkbfa-rss-square',
			'epkbfa-play-circle'           => 'epkbfa-play-circle',
			'epkbfa-ticket'                => 'epkbfa-ticket',
			'epkbfa-minus-square'          => 'epkbfa-minus-square',
			'epkbfa-minus-square-o'        => 'epkbfa-minus-square-o',
			'epkbfa-level-up'              => 'epkbfa-level-up',
			'epkbfa-level-down'            => 'epkbfa-level-down',
			'epkbfa-check-square'          => 'epkbfa-check-square',
			'epkbfa-pencil-square'         => 'epkbfa-pencil-square',
			'epkbfa-external-link-square'  => 'epkbfa-external-link-square',
			'epkbfa-share-square'          => 'epkbfa-share-square',
			'epkbfa-compass'               => 'epkbfa-compass',
			'epkbfa-toggle-down'           => 'epkbfa-toggle-down',
			'epkbfa-toggle-up'             => 'epkbfa-toggle-up',
			'epkbfa-toggle-right'          => 'epkbfa-toggle-right',
			'epkbfa-euro'                  => 'epkbfa-euro',
			'epkbfa-eur'                   => 'epkbfa-eur',
			'epkbfa-gbp'                   => 'epkbfa-gbp',
			'epkbfa-dollar'                => 'epkbfa-dollar',
			'epkbfa-rupee'                 => 'epkbfa-rupee',
			'epkbfa-inr'                   => 'epkbfa-inr',
			'epkbfa-cny'                   => 'epkbfa-cny',
			'epkbfa-rmb'                   => 'epkbfa-rmb',
			'epkbfa-yen'                   => 'epkbfa-yen',
			'epkbfa-jpy'                   => 'epkbfa-jpy',
			'epkbfa-ruble'                 => 'epkbfa-ruble',
			'epkbfa-rouble'                => 'epkbfa-rouble',
			'epkbfa-rub'                   => 'epkbfa-rub',
			'epkbfa-won'                   => 'epkbfa-won',
			'epkbfa-krw'                   => 'epkbfa-krw',
			'epkbfa-bitcoin'               => 'epkbfa-bitcoin',
			'epkbfa-btc'                   => 'epkbfa-btc',
			'epkbfa-file'                  => 'epkbfa-file',
			'epkbfa-file-text'             => 'epkbfa-file-text',
			'epkbfa-sort-alpha-asc'        => 'epkbfa-sort-alpha-asc',
			'epkbfa-sort-alpha-desc'       => 'epkbfa-sort-alpha-desc',
			'epkbfa-sort-amount-asc'       => 'epkbfa-sort-amount-asc',
			'epkbfa-sort-amount-desc'      => 'epkbfa-sort-amount-desc',
			'epkbfa-sort-numeric-asc'      => 'epkbfa-sort-numeric-asc',
			'epkbfa-sort-numeric-desc'     => 'epkbfa-sort-numeric-desc',
			'epkbfa-thumbs-up'             => 'epkbfa-thumbs-up',
			'epkbfa-thumbs-down'           => 'epkbfa-thumbs-down',
			'epkbfa-youtube-square'        => 'epkbfa-youtube-square',
			'epkbfa-youtube'               => 'epkbfa-youtube',
			'epkbfa-xing'                  => 'epkbfa-xing',
			'epkbfa-xing-square'           => 'epkbfa-xing-square',
			'epkbfa-dropbox'               => 'epkbfa-dropbox',
			'epkbfa-stack-overflow'        => 'epkbfa-stack-overflow',
			'epkbfa-instagram'             => 'epkbfa-instagram',
			'epkbfa-flickr'                => 'epkbfa-flickr',
			'epkbfa-adn'                   => 'epkbfa-adn',
			'epkbfa-bitbucket'             => 'epkbfa-bitbucket',
			'epkbfa-bitbucket-square'      => 'epkbfa-bitbucket-square',
			'epkbfa-tumblr'                => 'epkbfa-tumblr',
			'epkbfa-tumblr-square'         => 'epkbfa-tumblr-square',
			'epkbfa-long-arrow-down'       => 'epkbfa-long-arrow-down',
			'epkbfa-long-arrow-up'         => 'epkbfa-long-arrow-up',
			'epkbfa-long-arrow-left'       => 'epkbfa-long-arrow-left',
			'epkbfa-long-arrow-right'      => 'epkbfa-long-arrow-right',
			'epkbfa-apple'                 => 'epkbfa-apple',
			'epkbfa-windows'               => 'epkbfa-windows',
			'epkbfa-android'               => 'epkbfa-android',
			'epkbfa-linux'                 => 'epkbfa-linux',
			'epkbfa-dribbble'              => 'epkbfa-dribbble',
			'epkbfa-skype'                 => 'epkbfa-skype',
			'epkbfa-foursquare'            => 'epkbfa-foursquare',
			'epkbfa-trello'                => 'epkbfa-trello',
			'epkbfa-female'                => 'epkbfa-female',
			'epkbfa-male'                  => 'epkbfa-male',
			'epkbfa-gittip'                => 'epkbfa-gittip',
			'epkbfa-gratipay'              => 'epkbfa-gratipay',
			'epkbfa-sun-o'                 => 'epkbfa-sun-o',
			'epkbfa-moon-o'                => 'epkbfa-moon-o',
			'epkbfa-archive'               => 'epkbfa-archive',
			'epkbfa-bug'                   => 'epkbfa-bug',
			'epkbfa-vk'                    => 'epkbfa-vk',
			'epkbfa-weibo'                 => 'epkbfa-weibo',
			'epkbfa-renren'                => 'epkbfa-renren',
			'epkbfa-pagelines'             => 'epkbfa-pagelines',
			'epkbfa-stack-exchange'        => 'epkbfa-stack-exchange',
			'epkbfa-arrow-circle-o-right'  => 'epkbfa-arrow-circle-o-right',
			'epkbfa-arrow-circle-o-left'   => 'epkbfa-arrow-circle-o-left',
			'epkbfa-toggle-left'           => 'epkbfa-toggle-left',
			'epkbfa-dot-circle-o'          => 'epkbfa-dot-circle-o',
			'epkbfa-wheelchair'            => 'epkbfa-wheelchair',
			'epkbfa-vimeo-square'          => 'epkbfa-vimeo-square',
			'epkbfa-turkish-lira'          => 'epkbfa-turkish-lira',
			'epkbfa-try'                   => 'epkbfa-try',
			'epkbfa-plus-square-o'         => 'epkbfa-plus-square-o',
			'epkbfa-space-shuttle'         => 'epkbfa-space-shuttle',
			'epkbfa-slack'                 => 'epkbfa-slack',
			'epkbfa-envelope-square'       => 'epkbfa-envelope-square',
			'epkbfa-wordpress'             => 'epkbfa-wordpress',
			'epkbfa-openid'                => 'epkbfa-openid',
			'epkbfa-bank'                  => 'epkbfa-bank',
			'epkbfa-graduation-cap'        => 'epkbfa-graduation-cap',
			'epkbfa-yahoo'                 => 'epkbfa-yahoo',
			'epkbfa-google'                => 'epkbfa-google',
			'epkbfa-reddit'                => 'epkbfa-reddit',
			'epkbfa-reddit-square'         => 'epkbfa-reddit-square',
			'epkbfa-stumbleupon-circle'    => 'epkbfa-stumbleupon-circle',
			'epkbfa-stumbleupon'           => 'epkbfa-stumbleupon',
			'epkbfa-delicious'             => 'epkbfa-delicious',
			'epkbfa-digg'                  => 'epkbfa-digg',
			'epkbfa-pied-piper-pp'         => 'epkbfa-pied-piper-pp',
			'epkbfa-pied-piper-alt'        => 'epkbfa-pied-piper-alt',
			'epkbfa-drupal'                => 'epkbfa-drupal',
			'epkbfa-joomla'                => 'epkbfa-joomla',
			'epkbfa-language'              => 'epkbfa-language',
			'epkbfa-fax'                   => 'epkbfa-fax',
			'epkbfa-building'              => 'epkbfa-building',
			'epkbfa-child'                 => 'epkbfa-child',
			'epkbfa-paw'                   => 'epkbfa-paw',
			'epkbfa-spoon'                 => 'epkbfa-spoon',
			'epkbfa-cube'                  => 'epkbfa-cube',
			'epkbfa-cubes'                 => 'epkbfa-cubes',
			'epkbfa-behance'               => 'epkbfa-behance',
			'epkbfa-behance-square'        => 'epkbfa-behance-square',
			'epkbfa-steam'                 => 'epkbfa-steam',
			'epkbfa-steam-square'          => 'epkbfa-steam-square',
			'epkbfa-recycle'               => 'epkbfa-recycle',
			'epkbfa-car'                   => 'epkbfa-car',
			'epkbfa-cab'                   => 'epkbfa-cab',
			'epkbfa-taxi'                  => 'epkbfa-taxi',
			'epkbfa-tree'                  => 'epkbfa-tree',
			'epkbfa-spotify'               => 'epkbfa-spotify',
			'epkbfa-deviantart'            => 'epkbfa-deviantart',
			'epkbfa-soundcloud'            => 'epkbfa-soundcloud',
			'epkbfa-vine'                  => 'epkbfa-vine',
			'epkbfa-codepen'               => 'epkbfa-codepen',
			'epkbfa-jsfiddle'              => 'epkbfa-jsfiddle',
			'epkbfa-life-saver'            => 'epkbfa-life-saver',
			'epkbfa-circle-o-notch'        => 'epkbfa-circle-o-notch',
			'epkbfa-rebel'                 => 'epkbfa-rebel',
			'epkbfa-ge'                    => 'epkbfa-ge',
			'epkbfa-empire'                => 'epkbfa-empire',
			'epkbfa-git-square'            => 'epkbfa-git-square',
			'epkbfa-git'                   => 'epkbfa-git',
			'epkbfa-yc-square'             => 'epkbfa-yc-square',
			'epkbfa-hacker-news'           => 'epkbfa-hacker-news',
			'epkbfa-tencent-weibo'         => 'epkbfa-tencent-weibo',
			'epkbfa-qq'                    => 'epkbfa-qq',
			'epkbfa-wechat'                => 'epkbfa-wechat',
			'epkbfa-paper-plane'           => 'epkbfa-paper-plane',
			'epkbfa-paper-plane-o'         => 'epkbfa-paper-plane-o',
			'epkbfa-history'               => 'epkbfa-history',
			'epkbfa-circle-thin'           => 'epkbfa-circle-thin',
			'epkbfa-header'                => 'epkbfa-header',
			'epkbfa-paragraph'             => 'epkbfa-paragraph',
			'epkbfa-sliders'               => 'epkbfa-sliders',
			'epkbfa-share-alt'             => 'epkbfa-share-alt',
			'epkbfa-share-alt-square'      => 'epkbfa-share-alt-square',
			'epkbfa-bomb'                  => 'epkbfa-bomb',
			'epkbfa-soccer-ball-o'         => 'epkbfa-soccer-ball-o',
			'epkbfa-futbol-o'              => 'epkbfa-futbol-o',
			'epkbfa-tty'                   => 'epkbfa-tty',
			'epkbfa-binoculars'            => 'epkbfa-binoculars',
			'epkbfa-plug'                  => 'epkbfa-plug',
			'epkbfa-slideshare'            => 'epkbfa-slideshare',
			'epkbfa-twitch'                => 'epkbfa-twitch',
			'epkbfa-yelp'                  => 'epkbfa-yelp',
			'epkbfa-newspaper-o'           => 'epkbfa-newspaper-o',
			'epkbfa-wifi'                  => 'epkbfa-wifi',
			'epkbfa-calculator'            => 'epkbfa-calculator',
			'epkbfa-paypal'                => 'epkbfa-paypal',
			'epkbfa-google-wallet'         => 'epkbfa-google-wallet',
			'epkbfa-cc-visa'               => 'epkbfa-cc-visa',
			'epkbfa-cc-mastercard'         => 'epkbfa-cc-mastercard',
			'epkbfa-cc-discover'           => 'epkbfa-cc-discover',
			'epkbfa-cc-amex'               => 'epkbfa-cc-amex',
			'epkbfa-cc-paypal'             => 'epkbfa-cc-paypal',
			'epkbfa-cc-stripe'             => 'epkbfa-cc-stripe',
			'epkbfa-bell-slash'            => 'epkbfa-bell-slash',
			'epkbfa-bell-slash-o'          => 'epkbfa-bell-slash-o',
			'epkbfa-trash'                 => 'epkbfa-trash',
			'epkbfa-copyright'             => 'epkbfa-copyright',
			'epkbfa-at'                    => 'epkbfa-at',
			'epkbfa-eyedropper'            => 'epkbfa-eyedropper',
			'epkbfa-paint-brush'           => 'epkbfa-paint-brush',
			'epkbfa-birthday-cake'         => 'epkbfa-birthday-cake',
			'epkbfa-area-chart'            => 'epkbfa-area-chart',
			'epkbfa-pie-chart'             => 'epkbfa-pie-chart',
			'epkbfa-line-chart'            => 'epkbfa-line-chart',
			'epkbfa-lastfm'                => 'epkbfa-lastfm',
			'epkbfa-lastfm-square'         => 'epkbfa-lastfm-square',
			'epkbfa-toggle-off'            => 'epkbfa-toggle-off',
			'epkbfa-toggle-on'             => 'epkbfa-toggle-on',
			'epkbfa-bicycle'               => 'epkbfa-bicycle',
			'epkbfa-bus'                   => 'epkbfa-bus',
			'epkbfa-ioxhost'               => 'epkbfa-ioxhost',
			'epkbfa-angellist'             => 'epkbfa-angellist',
			'epkbfa-cc'                    => 'epkbfa-cc',
			'epkbfa-shekel'                => 'epkbfa-shekel',
			'epkbfa-sheqel'                => 'epkbfa-sheqel',
			'epkbfa-ils'                   => 'epkbfa-ils',
			'epkbfa-meanpath'              => 'epkbfa-meanpath',
			'epkbfa-buysellads'            => 'epkbfa-buysellads',
			'epkbfa-connectdevelop'        => 'epkbfa-connectdevelop',
			'epkbfa-dashcube'              => 'epkbfa-dashcube',
			'epkbfa-forumbee'              => 'epkbfa-forumbee',
			'epkbfa-leanpub'               => 'epkbfa-leanpub',
			'epkbfa-sellsy'                => 'epkbfa-sellsy',
			'epkbfa-shirtsinbulk'          => 'epkbfa-shirtsinbulk',
			'epkbfa-simplybuilt'           => 'epkbfa-simplybuilt',
			'epkbfa-skyatlas'              => 'epkbfa-skyatlas',
			'epkbfa-cart-plus'             => 'epkbfa-cart-plus',
			'epkbfa-cart-arrow-down'       => 'epkbfa-cart-arrow-down',
			'epkbfa-diamond'               => 'epkbfa-diamond',
			'epkbfa-ship'                  => 'epkbfa-ship',
			'epkbfa-user-secret'           => 'epkbfa-user-secret',
			'epkbfa-motorcycle'            => 'epkbfa-motorcycle',
			'epkbfa-street-view'           => 'epkbfa-street-view',
			'epkbfa-heartbeat'             => 'epkbfa-heartbeat',
			'epkbfa-venus'                 => 'epkbfa-venus',
			'epkbfa-mars'                  => 'epkbfa-mars',
			'epkbfa-mercury'               => 'epkbfa-mercury',
			'epkbfa-intersex'              => 'epkbfa-intersex',
			'epkbfa-transgender-alt'       => 'epkbfa-transgender-alt',
			'epkbfa-venus-double'          => 'epkbfa-venus-double',
			'epkbfa-mars-double'           => 'epkbfa-mars-double',
			'epkbfa-venus-mars'            => 'epkbfa-venus-mars',
			'epkbfa-mars-stroke'           => 'epkbfa-mars-stroke',
			'epkbfa-mars-stroke-v'         => 'epkbfa-mars-stroke-v',
			'epkbfa-mars-stroke-h'         => 'epkbfa-mars-stroke-h',
			'epkbfa-neuter'                => 'epkbfa-neuter',
			'epkbfa-genderless'            => 'epkbfa-genderless',
			'epkbfa-facebook-official'     => 'epkbfa-facebook-official',
			'epkbfa-pinterest-p'           => 'epkbfa-pinterest-p',
			'epkbfa-whatsapp'              => 'epkbfa-whatsapp',
			'epkbfa-server'                => 'epkbfa-server',
			'epkbfa-user-plus'             => 'epkbfa-user-plus',
			'epkbfa-user-times'            => 'epkbfa-user-times',
			'epkbfa-hotel'                 => 'epkbfa-hotel',
			'epkbfa-bed'                   => 'epkbfa-bed',
			'epkbfa-viacoin'               => 'epkbfa-viacoin',
			'epkbfa-train'                 => 'epkbfa-train',
			'epkbfa-subway'                => 'epkbfa-subway',
			'epkbfa-medium'                => 'epkbfa-medium',
			'epkbfa-yc'                    => 'epkbfa-yc',
			'epkbfa-optin-monster'         => 'epkbfa-optin-monster',
			'epkbfa-opencart'              => 'epkbfa-opencart',
			'epkbfa-expeditedssl'          => 'epkbfa-expeditedssl',
			'epkbfa-battery-full'          => 'epkbfa-battery-full',
			'epkbfa-battery-three-quarters' => 'epkbfa-battery-three-quarters',
			'epkbfa-battery-half'          => 'epkbfa-battery-half',
			'epkbfa-battery-quarter'       => 'epkbfa-battery-quarter',
			'epkbfa-battery-empty'         => 'epkbfa-battery-empty',
			'epkbfa-mouse-pointer'         => 'epkbfa-mouse-pointer',
			'epkbfa-i-cursor'              => 'epkbfa-i-cursor',
			'epkbfa-object-group'          => 'epkbfa-object-group',
			'epkbfa-object-ungroup'        => 'epkbfa-object-ungroup',
			'epkbfa-sticky-note'           => 'epkbfa-sticky-note',
			'epkbfa-sticky-note-o'         => 'epkbfa-sticky-note-o',
			'epkbfa-cc-jcb'                => 'epkbfa-cc-jcb',
			'epkbfa-cc-diners-club'        => 'epkbfa-cc-diners-club',
			'epkbfa-clone'                 => 'epkbfa-clone',
			'epkbfa-balance-scale'         => 'epkbfa-balance-scale',
			'epkbfa-hourglass-o'           => 'epkbfa-hourglass-o',
			'epkbfa-hourglass-start'       => 'epkbfa-hourglass-start',
			'epkbfa-hourglass-half'        => 'epkbfa-hourglass-half',
			'epkbfa-hourglass-end'         => 'epkbfa-hourglass-end',
			'epkbfa-hourglass'             => 'epkbfa-hourglass',
			'epkbfa-hand-rock-o'           => 'epkbfa-hand-rock-o',
			'epkbfa-hand-paper-o'          => 'epkbfa-hand-paper-o',
			'epkbfa-hand-scissors-o'       => 'epkbfa-hand-scissors-o',
			'epkbfa-hand-lizard-o'         => 'epkbfa-hand-lizard-o',
			'epkbfa-hand-spock-o'          => 'epkbfa-hand-spock-o',
			'epkbfa-hand-pointer-o'        => 'epkbfa-hand-pointer-o',
			'epkbfa-hand-peace-o'          => 'epkbfa-hand-peace-o',
			'epkbfa-trademark'             => 'epkbfa-trademark',
			'epkbfa-registered'            => 'epkbfa-registered',
			'epkbfa-creative-commons'      => 'epkbfa-creative-commons',
			'epkbfa-gg'                    => 'epkbfa-gg',
			'epkbfa-gg-circle'             => 'epkbfa-gg-circle',
			'epkbfa-tripadvisor'           => 'epkbfa-tripadvisor',
			'epkbfa-odnoklassniki'         => 'epkbfa-odnoklassniki',
			'epkbfa-odnoklassniki-square'  => 'epkbfa-odnoklassniki-square',
			'epkbfa-get-pocket'            => 'epkbfa-get-pocket',
			'epkbfa-wikipedia-w'           => 'epkbfa-wikipedia-w',
			'epkbfa-safari'                => 'epkbfa-safari',
			'epkbfa-chrome'                => 'epkbfa-chrome',
			'epkbfa-firefox'               => 'epkbfa-firefox',
			'epkbfa-opera'                 => 'epkbfa-opera',
			'epkbfa-internet-explorer'     => 'epkbfa-internet-explorer',
			'epkbfa-tv'                    => 'epkbfa-tv',
			'epkbfa-contao'                => 'epkbfa-contao',
			'epkbfa-500px'                 => 'epkbfa-500px',
			'epkbfa-amazon'                => 'epkbfa-amazon',
			'epkbfa-calendar-plus-o'       => 'epkbfa-calendar-plus-o',
			'epkbfa-calendar-minus-o'      => 'epkbfa-calendar-minus-o',
			'epkbfa-calendar-times-o'      => 'epkbfa-calendar-times-o',
			'epkbfa-calendar-check-o'      => 'epkbfa-calendar-check-o',
			'epkbfa-industry'              => 'epkbfa-industry',
			'epkbfa-map-pin'               => 'epkbfa-map-pin',
			'epkbfa-map-signs'             => 'epkbfa-map-signs',
			'epkbfa-map-o'                 => 'epkbfa-map-o',
			'epkbfa-map'                   => 'epkbfa-map',
			'epkbfa-commenting'            => 'epkbfa-commenting',
			'epkbfa-commenting-o'          => 'epkbfa-commenting-o',
			'epkbfa-houzz'                 => 'epkbfa-houzz',
			'epkbfa-vimeo'                 => 'epkbfa-vimeo',
			'epkbfa-black-tie'             => 'epkbfa-black-tie',
			'epkbfa-fonticons'             => 'epkbfa-fonticons',
			'epkbfa-reddit-alien'          => 'epkbfa-reddit-alien',
			'epkbfa-edge'                  => 'epkbfa-edge',
			'epkbfa-credit-card-alt'       => 'epkbfa-credit-card-alt',
			'epkbfa-codiepie'              => 'epkbfa-codiepie',
			'epkbfa-modx'                  => 'epkbfa-modx',
			'epkbfa-fort-awesome'          => 'epkbfa-fort-awesome',
			'epkbfa-usb'                   => 'epkbfa-usb',
			'epkbfa-product-hunt'          => 'epkbfa-product-hunt',
			'epkbfa-mixcloud'              => 'epkbfa-mixcloud',
			'epkbfa-scribd'                => 'epkbfa-scribd',
			'epkbfa-pause-circle'          => 'epkbfa-pause-circle',
			'epkbfa-pause-circle-o'        => 'epkbfa-pause-circle-o',
			'epkbfa-stop-circle'           => 'epkbfa-stop-circle',
			'epkbfa-stop-circle-o'         => 'epkbfa-stop-circle-o',
			'epkbfa-shopping-bag'          => 'epkbfa-shopping-bag',
			'epkbfa-shopping-basket'       => 'epkbfa-shopping-basket',
			'epkbfa-hashtag'               => 'epkbfa-hashtag',
			'epkbfa-bluetooth'             => 'epkbfa-bluetooth',
			'epkbfa-bluetooth-b'           => 'epkbfa-bluetooth-b',
			'epkbfa-percent'               => 'epkbfa-percent',
			'epkbfa-gitlab'                => 'epkbfa-gitlab',
			'epkbfa-wpbeginner'            => 'epkbfa-wpbeginner',
			'epkbfa-wpforms'               => 'epkbfa-wpforms',
			'epkbfa-envira'                => 'epkbfa-envira',
			'epkbfa-universal-access'      => 'epkbfa-universal-access',
			'epkbfa-wheelchair-alt'        => 'epkbfa-wheelchair-alt',
			'epkbfa-question-circle-o'     => 'epkbfa-question-circle-o',
			'epkbfa-blind'                 => 'epkbfa-blind',
			'epkbfa-audio-description'     => 'epkbfa-audio-description',
			'epkbfa-volume-control-phone'  => 'epkbfa-volume-control-phone',
			'epkbfa-braille'               => 'epkbfa-braille',
			'epkbfa-assistive-listening-systems' => 'epkbfa-assistive-listening-systems',
			'epkbfa-american-sign-language-interpreting' => 'epkbfa-american-sign-language-interpreting',
			'epkbfa-hard-of-hearing'       => 'epkbfa-hard-of-hearing',
			'epkbfa-glide'                 => 'epkbfa-glide',
			'epkbfa-glide-g'               => 'epkbfa-glide-g',
			'epkbfa-sign-language'         => 'epkbfa-sign-language',
			'epkbfa-low-vision'            => 'epkbfa-low-vision',
			'epkbfa-viadeo'                => 'epkbfa-viadeo',
			'epkbfa-viadeo-square'         => 'epkbfa-viadeo-square',
			'epkbfa-snapchat'              => 'epkbfa-snapchat',
			'epkbfa-snapchat-ghost'        => 'epkbfa-snapchat-ghost',
			'epkbfa-snapchat-square'       => 'epkbfa-snapchat-square',
			'epkbfa-pied-piper'            => 'epkbfa-pied-piper',
			'epkbfa-first-order'           => 'epkbfa-first-order',
			'epkbfa-yoast'                 => 'epkbfa-yoast',
			'epkbfa-themeisle'             => 'epkbfa-themeisle',
			'epkbfa-google-plus-circle'    => 'epkbfa-google-plus-circle',
			'epkbfa-google-plus-official'  => 'epkbfa-google-plus-official',
			'epkbfa-font-awesome'          => 'epkbfa-font-awesome',
			'epkbfa-handshake-o'           => 'epkbfa-handshake-o',
			'epkbfa-envelope-open'         => 'epkbfa-envelope-open',
			'epkbfa-envelope-open-o'       => 'epkbfa-envelope-open-o',
			'epkbfa-linode'                => 'epkbfa-linode',
			'epkbfa-address-book'          => 'epkbfa-address-book',
			'epkbfa-address-book-o'        => 'epkbfa-address-book-o',
			'epkbfa-address-card'          => 'epkbfa-address-card',
			'epkbfa-address-card-o'        => 'epkbfa-address-card-o',
			'epkbfa-user-circle'           => 'epkbfa-user-circle',
			'epkbfa-user-circle-o'         => 'epkbfa-user-circle-o',
			'epkbfa-user-o'                => 'epkbfa-user-o',
			'epkbfa-id-badge'              => 'epkbfa-id-badge',
			'epkbfa-id-card'               => 'epkbfa-id-card',
			'epkbfa-id-card-o'             => 'epkbfa-id-card-o',
			'epkbfa-quora'                 => 'epkbfa-quora',
			'epkbfa-free-code-camp'        => 'epkbfa-free-code-camp',
			'epkbfa-telegram'              => 'epkbfa-telegram',
			'epkbfa-thermometer-full'      => 'epkbfa-thermometer-full',
			'epkbfa-thermometer-three-quarters' => 'epkbfa-thermometer-three-quarters',
			'epkbfa-thermometer-half'      => 'epkbfa-thermometer-half',
			'epkbfa-thermometer-quarter'   => 'epkbfa-thermometer-quarter',
			'epkbfa-thermometer-0'         => 'epkbfa-thermometer-0'       ,
			'epkbfa-thermometer-empty'     => 'epkbfa-thermometer-empty',
			'epkbfa-shower'                => 'epkbfa-shower',
			'epkbfa-bathtub'               => 'epkbfa-bathtub'       ,
			'epkbfa-s15'                   => 'epkbfa-s15'       ,
			'epkbfa-podcast'               => 'epkbfa-podcast',
			'epkbfa-window-maximize'       => 'epkbfa-window-maximize',
			'epkbfa-window-minimize'       => 'epkbfa-window-minimize',
			'epkbfa-window-restore'        => 'epkbfa-window-restore',
			'epkbfa-window-close'          => 'epkbfa-window-close',
			'epkbfa-window-close-o'        => 'epkbfa-window-close-o',
			'epkbfa-bandcamp'              => 'epkbfa-bandcamp',
			'epkbfa-grav'                  => 'epkbfa-grav',
			'epkbfa-etsy'                  => 'epkbfa-etsy',
			'epkbfa-imdb'                  => 'epkbfa-imdb',
			'epkbfa-ravelry'               => 'epkbfa-ravelry',
			'epkbfa-eercast'               => 'epkbfa-eercast',
			'epkbfa-microchip'             => 'epkbfa-microchip',
			'epkbfa-snowflake-o'           => 'epkbfa-snowflake-o',
			'epkbfa-superpowers'           => 'epkbfa-superpowers',
			'epkbfa-wpexplorer'            => 'epkbfa-wpexplorer',
			'epkbfa-meetup'                => 'epkbfa-meetup'
		);
		ksort($all_icons);

		return $all_icons;
	}

	private static function format_font_awesome_icon_name( $value ) {

		// if icon name starts with 'fa-' then create its name
		if (strpos( $value, 'fa-') === 0) {
			// remove spaces and capitalise each word
			$value = ucwords( str_replace( array('fa-','-'), " ", $value ) );
		} elseif (strpos( $value, 'epkbfa-') === 0 ) {
			// remove spaces and capitalise each word
			$value = ucwords( str_replace( array('epkbfa-','-'), " ", $value ) );
		}

		return $value;
	}

	/**
	 * Show or return icons pack html
	 *
	 * @param bool $display - bool, show or return
	 * @param string $checked - key of the checked icon
	 * @return false|string
	 */
	public static function get_icons_pack_html( $display = true, $checked = '' ) {
		$all_icons = self::get_epkbfa_all_icons();
		
		ob_start(); ?>
		
		<div class="epkb-icon-pack"> <?php 
			foreach ( $all_icons as $key => $label ) { ?>
				<div class="epkb-icon-pack__icon <?php echo ( $checked == $key ) ? 'epkb-icon-pack__icon--checked' : ''; ?>" 
					data-key="<?php echo esc_attr( $key ); ?>"
					data-label="<?php echo esc_html( self::format_font_awesome_icon_name( $label ) );        ?>"
				>
					<i class="epkbfa <?php echo esc_html( $key );  ?>"></i>
				</div><?php 
			} ?>
		</div> <?php 
		
		$html_escaped = ob_get_clean();
		
		if ( $display ) {
			echo $html_escaped;
		}
		
		return $html_escaped;
	}

	/**
	 * Theme image has local URL
	 *
	 * @param $kb_config
	 * @return bool
	 */
	public static function is_theme_with_image_icons( $kb_config ) {
		return ! empty( $kb_config['theme_name'] ) && in_array( $kb_config['theme_name'], array(
				'modern',
				'modern_tabs',
				'image',
				'image_tabs',
				'office',
				'office_tabs',
				'office_categories',
				'elegant',
				'elegant_tabs',
				'creative',
				'creative_tabs',
				'creative_categories',
				'creative_classic',
				'creative_drill_down',
				'bright',
				'formal',
				'formal_tabs',
				'formal_categories',
				'standard_classic',
				'standard_drill_down',
				'grid_basic',
				'grid_demo_9'
			) );
	}

	/**
	 * Theme photo has third-party URL
	 *
	 * @param $theme_name
	 * @return bool
	 */
	public static function is_theme_with_photo_icons( $theme_name ) {
		return ! empty( $theme_name ) && in_array( $theme_name, array(
				'image',
				'image_tabs',
			) );
	}

	/**
	 * Return images or photos for theme icons; use default font icons if not defined
	 *
	 * @param $theme_name
	 * @return string[]
	 */
	public static function get_theme_image_icons( $theme_name ) {

		$theme_icons = array(
			'default' => array( // used for modern, office, elegant, grid_basic, standard_classic
				'image_1'                               => 'img/demo-icons/icons/pink-kb-icon-laptop-100.png',
				'image_2'                               => 'img/demo-icons/icons/pink-kb-icon-bar-chart-100.png',
				'image_3'                               => 'img/demo-icons/icons/pink-kb-icon-notepad-100.png',
				'image_4'                               => 'img/demo-icons/icons/pink-kb-icon-lightbulb-100.png',
				'image_5'                               => 'img/demo-icons/icons/pink-kb-icon-briefcase-100.png',
				'image_6'                               => 'img/demo-icons/icons/pink-kb-icon-handshake-100.png',
			),
			'standard_drill_down' => array(
				'image_1'                               => 'img/demo-icons/icons/pink-kb-icon-laptop-100.png',
				'image_2'                               => 'img/demo-icons/icons/pink-kb-icon-bar-chart-100.png',
				'image_3'                               => 'img/demo-icons/icons/pink-kb-icon-notepad-100.png',
				'image_4'                               => 'img/demo-icons/icons/pink-kb-icon-lightbulb-100.png',
				'image_5'                               => 'img/demo-icons/icons/pink-kb-icon-briefcase-100.png',
				'image_6'                               => 'img/demo-icons/icons/pink-kb-icon-handshake-100.png',
			),
			'image' => array(
				'image_1'                               => 'https://www.echoknowledgebase.com/wp-content/uploads/2021/02/faqs-2-example.jpg',
				'image_2'                               => 'https://www.echoknowledgebase.com/wp-content/uploads/2021/02/users-example.jpg',
				'image_3'                               => 'https://www.echoknowledgebase.com/wp-content/uploads/2021/02/getting-started-example.jpg',
				'image_4'                               => 'https://www.echoknowledgebase.com/wp-content/uploads/2021/02/operations-example.jpg',
				'image_5'                               => 'https://www.echoknowledgebase.com/wp-content/uploads/2021/02/reports-and-analytics-example.jpg',
				'image_6'                               => 'https://www.echoknowledgebase.com/wp-content/uploads/2021/02/tutorials-and-tips-example.jpg'
			),
			'creative' => array(
				'image_1'                               => 'img/demo-icons/icons/blue-background-book.jpg',
				'image_2'                               => 'img/demo-icons/icons/blue-background-bulb-laptop.jpg',
				'image_3'                               => 'img/demo-icons/icons/blue-background-laptop.jpg',
				'image_4'                               => 'img/demo-icons/icons/blue-background-rocket.jpg',
				'image_5'                               => 'img/demo-icons/icons/blue-background-big-bulb.jpg',
				'image_6'                               => 'img/demo-icons/icons/blue-background-chemical.jpg',
			),
			'creative_classic' => array(
				'image_1'                               => 'img/demo-icons/icons/square-book.jpg',
				'image_2'                               => 'img/demo-icons/icons/square-bulb-laptop.jpg',
				'image_3'                               => 'img/demo-icons/icons/square-laptop.jpg',
				'image_4'                               => 'img/demo-icons/icons/square-rocket.jpg',
				'image_5'                               => 'img/demo-icons/icons/square-big-bulb.jpg',
				'image_6'                               => 'img/demo-icons/icons/square-chemical.jpg',
			),
			'bright' => array(
				'image_1'                               => 'img/demo-icons/icons/yellow-background-briefcase.jpg',
				'image_2'                               => 'img/demo-icons/icons/yellow-background-calculator.jpg',
				'image_3'                               => 'img/demo-icons/icons/yellow-background-coffee.jpg',
				'image_4'                               => 'img/demo-icons/icons/yellow-background-laptop.jpg',
				'image_5'                               => 'img/demo-icons/icons/yellow-background-notepad.jpg',
				'image_6'                               => 'img/demo-icons/icons/yellow-background-printer.jpg',
			),
			'formal' => array(
				'image_1'                               => 'img/demo-icons/icons/red-icon-calculator.png',
				'image_2'                               => 'img/demo-icons/icons/red-icon-cell.png',
				'image_3'                               => 'img/demo-icons/icons/red-icon-info.png',
				'image_4'                               => 'img/demo-icons/icons/red-icon-laptop.png',
				'image_5'                               => 'img/demo-icons/icons/red-icon-lock.png',
				'image_6'                               => 'img/demo-icons/icons/red-icon-notebook.png',
			),
			'grid_demo_9' => array(
				'image_1'                               => 'img/demo-icons/icons/yellow-background-briefcase-square.jpg',
				'image_2'                               => 'img/demo-icons/icons/yellow-background-calculator-square.jpg',
				'image_3'                               => 'img/demo-icons/icons/yellow-background-coffee-square.jpg',
				'image_4'                               => 'img/demo-icons/icons/yellow-background-laptop-square.jpg',
				'image_5'                               => 'img/demo-icons/icons/yellow-background-notepad-square.jpg',
				'image_6'                               => 'img/demo-icons/icons/yellow-background-printer-square.jpg',
			),
		);

		// made duplicates of the following:
		$theme_icons['image_tabs'] = $theme_icons['image'];
		$theme_icons['creative_drill_down'] = $theme_icons['creative_classic'];
		$theme_icons['creative_tabs'] = $theme_icons['creative'];
		$theme_icons['creative_categories'] = $theme_icons['creative'];
		$theme_icons['formal_tabs'] = $theme_icons['formal'];
		$theme_icons['formal_categories'] = $theme_icons['formal'];

		return isset( $theme_icons[$theme_name] ) ? $theme_icons[$theme_name] : $theme_icons['default'];
	}
}